package ru.yandex.direct.excel.processing.model.internalad.mappers;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.commons.collections4.CollectionUtils;

import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.excel.processing.model.ColumnsWithChoices;
import ru.yandex.direct.excel.processing.model.internalad.CryptaSegment;
import ru.yandex.direct.excel.processing.model.internalad.RetargetingConditionRepresentation;
import ru.yandex.direct.excel.processing.service.internalad.CryptaSegmentDictionariesService;
import ru.yandex.direct.excelmapper.ExcelMapper;
import ru.yandex.direct.excelmapper.mappers.MaybeEmptyExcelMapper;

import static ru.yandex.direct.excelmapper.ExcelMappers.longMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.maybeListMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.objectMapper;
import static ru.yandex.direct.excelmapper.ExcelMappers.stringMapper;

@ParametersAreNonnullByDefault
public class RetargetingBaseMappers {

    private static final String GENDER_COLUMN_TITLE = "Пол";
    private static final String AGE_TITLE = "Возраст";
    public static final String INCOME_TITLE = "Доход";

    private RetargetingBaseMappers() {
    }

    static ExcelMapper<RetargetingConditionRepresentation> getRetargetingMapper(
            CryptaSegmentDictionariesService cryptaSegmentDictionariesService) {
        return objectMapper(() -> new RetargetingConditionRepresentation(cryptaSegmentDictionariesService))
                .field(RetargetingConditionRepresentation::getGoalContext,
                        RetargetingConditionRepresentation::setGoalContext,
                        maybeGoalContextMapper("Ретаргетинг GoalContext"))
                .field(RetargetingConditionRepresentation::getAudience,
                        RetargetingConditionRepresentation::setAudience,
                        maybeListMapper(longMapper("Аудитории")))
                .field(RetargetingConditionRepresentation::getAudienceNot,
                        RetargetingConditionRepresentation::setAudienceNot,
                        maybeListMapper(longMapper("Аудитории не")))
                .field(RetargetingConditionRepresentation::getCrypta,
                        RetargetingConditionRepresentation::setCrypta,
                        maybeListCryptaSegmentMapper("Крипта"))
                .field(RetargetingConditionRepresentation::getCryptaNot,
                        RetargetingConditionRepresentation::setCryptaNot,
                        maybeListCryptaSegmentMapper("Крипта не"))
                .field(RetargetingConditionRepresentation::getSocialDemoGender,
                        RetargetingConditionRepresentation::setSocialDemoGender,
                        maybeListMapper(stringMapper(GENDER_COLUMN_TITLE)))
                .field(RetargetingConditionRepresentation::getSocialDemoAge,
                        RetargetingConditionRepresentation::setSocialDemoAge,
                        maybeListMapper(stringMapper(AGE_TITLE)))
                .field(RetargetingConditionRepresentation::getSocialDemoIncome,
                        RetargetingConditionRepresentation::setSocialDemoIncome,
                        maybeListMapper(stringMapper(INCOME_TITLE)))
                .build();
    }

    public static ExcelMapper<List<CryptaSegment>> maybeListCryptaSegmentMapper(String title) {
        return maybeListMapper(new CryptaSegmentMapper(title));
    }

    public static ExcelMapper<List<Rule>> maybeGoalContextMapper(String title) {
        return new MaybeEmptyExcelMapper<>(new GoalContextMapper(title), CollectionUtils::isEmpty, List::of);
    }

    static List<ColumnsWithChoices> getRetargetingsColumnsWithChoices(
            CryptaSegmentDictionariesService cryptaSegmentDictionariesService) {
        return ColumnsWithChoices.listBuilder()
                .addColumnTitlesWithChoices(Set.of(GENDER_COLUMN_TITLE),
                        cryptaSegmentDictionariesService.getGenderValues())
                .addColumnTitlesWithChoices(Set.of(AGE_TITLE),
                        cryptaSegmentDictionariesService.getAgeValues())
                .addColumnTitlesWithChoices(Set.of(INCOME_TITLE),
                        cryptaSegmentDictionariesService.getIncomeValues())
                .build();
    }

}
