package ru.yandex.direct.excel.processing.service.internalad;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.adgroup.model.AdGroup;
import ru.yandex.direct.core.entity.adgroup.model.InternalAdGroup;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingCondition;
import ru.yandex.direct.core.entity.retargeting.model.RetargetingConditionBase;
import ru.yandex.direct.core.entity.retargeting.model.Rule;
import ru.yandex.direct.excel.processing.model.internalad.AdGroupAdditionalTargetingRepresentation;
import ru.yandex.direct.excel.processing.model.internalad.InternalAdGroupRepresentation;
import ru.yandex.direct.excel.processing.model.internalad.InternalBannerRepresentation;
import ru.yandex.direct.excel.processing.model.internalad.RetargetingConditionRepresentation;

import static java.util.function.Function.identity;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@ParametersAreNonnullByDefault
class InternalAdConverter {

    private InternalAdConverter() {
    }

    static List<InternalAdGroupRepresentation> toAdGroupRepresentations(
            List<InternalAdGroup> adGroups, Map<Long, List<AdGroupAdditionalTargeting>> targetingsByAdGroup,
            CryptaSegmentDictionariesService cryptaSegmentDictionariesService,
            Map<Long, RetargetingCondition> retargetinConditionsByAdGroup
    ) {
        return StreamEx.of(adGroups)
                .map(adGroup -> {
                    List<Rule> rules = Optional.ofNullable(retargetinConditionsByAdGroup.get(adGroup.getId()))
                            .map(RetargetingConditionBase::getRules)
                            .orElse(Collections.emptyList());

                    return new InternalAdGroupRepresentation()
                            .setAdGroup(adGroup)
                            .setTargetingRepresentation(new AdGroupAdditionalTargetingRepresentation(
                                    targetingsByAdGroup.getOrDefault(adGroup.getId(), Collections.emptyList())))
                            .setRetargetingConditionRepresentation(
                                    new RetargetingConditionRepresentation(rules, cryptaSegmentDictionariesService));
                })
                .toImmutableList();
    }

    static Map<Long, List<InternalBannerRepresentation>> toBannerRepresentationsByTemplateId(
            List<InternalAdGroup> adGroups, List<InternalBanner> banners) {
        Map<Long, String> adGroupNames = listToMap(adGroups, AdGroup::getId, AdGroup::getName);

        return StreamEx.of(banners)
                .map(banner -> new InternalBannerRepresentation()
                        .setAdGroupName(adGroupNames.get(banner.getAdGroupId()))
                        .setBanner(banner)
                )
                .mapToEntry(r -> r.getBanner().getTemplateId(), identity())
                .grouping();
    }
}
