package ru.yandex.direct.excel.processing.service.internalad;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbookType;

import ru.yandex.direct.excel.processing.model.internalad.ExcelFetchedData;
import ru.yandex.direct.excel.processing.model.internalad.ExcelSheetFetchedData;
import ru.yandex.direct.excel.processing.model.internalad.SheetDescriptor;

@ParametersAreNonnullByDefault
class InternalAdExcelUtils {

    /**
     * На каждую группу/баннер должно быть <= MAX_ROWS_PER_OBJECT строк в экселе, иначе в файл может записаться строка,
     * которая частично заполнена
     * the number of rows that are kept in memory until flushed out, see above.
     */
    private static final int MAX_ROWS_PER_OBJECT = 2_000;

    private InternalAdExcelUtils() {
    }

    static Workbook loadWorkbook(InputStream excelFile) {
        try {
            return new XSSFWorkbook(excelFile);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static Set<Long> getCampaignIdsFromAllSheetDescriptors(ExcelFetchedData excelFetchedData) {
        Set<Long> campaignIds = new HashSet<>();
        campaignIds.add(excelFetchedData.getAdGroupsSheet().getSheetDescriptor().getCampaignId());

        Set<Long> adsSheetDescriptorCampaignId = StreamEx.of(excelFetchedData.getAdsSheets())
                .map(ExcelSheetFetchedData::getSheetDescriptor)
                .map(SheetDescriptor::getCampaignId)
                .toSet();
        campaignIds.addAll(adsSheetDescriptorCampaignId);

        return campaignIds;
    }

    static Workbook createEmptyWorkbook() {
        return new SXSSFWorkbook(new XSSFWorkbook(XSSFWorkbookType.XLSX), MAX_ROWS_PER_OBJECT);
    }

}
