package ru.yandex.direct.excel.processing.service.internalad;

import java.util.List;
import java.util.Set;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;

import ru.yandex.direct.excelmapper.SheetRange;

public class StyledSheetRange implements SheetRange {
    private final SheetRange sheetRange;
    private final CellStyle style;

    public StyledSheetRange(SheetRange sheetRange, CellStyle style) {
        this.sheetRange = sheetRange;
        this.style = style;
    }

    @Override
    public int getHeight() {
        return sheetRange.getHeight();
    }

    @Override
    public SheetRange makeSubRange(int offsetRows, int offsetCols, int subRangeHeight) {
        return new StyledSheetRange(sheetRange.makeSubRange(offsetRows, offsetCols, subRangeHeight), style);
    }

    @Override
    public SheetRange makeSubRange(int offsetRows, int offsetCols, HeightMode heightMode) {
        return new StyledSheetRange(sheetRange.makeSubRange(offsetRows, offsetCols, heightMode), style);
    }

    @Override
    public SheetRange makeSubRange(int offsetRows, int offsetCols) {
        return new StyledSheetRange(sheetRange.makeSubRange(offsetRows, offsetCols), style);
    }

    @Override
    public boolean isOffsetRowsInRange(int offsetRows) {
        return sheetRange.isOffsetRowsInRange(offsetRows);
    }

    @Override
    public Cell getCell(int row, int col) {
        Cell cell = sheetRange.getCell(row, col);
        cell.setCellStyle(style);
        return cell;
    }

    @Override
    public Cell getCellForWrite(int row, int col) {
        Cell cell = sheetRange.getCellForWrite(row, col);
        cell.setCellStyle(style);
        return cell;
    }

    @Override
    public Set<Integer> getColumnsWithNotEmptyValue() {
        return sheetRange.getColumnsWithNotEmptyValue();
    }

    @Override
    public void reportInvalidCellDataFormat(List<String> columns, int offsetRows, int offsetCols) {
        sheetRange.reportInvalidCellDataFormat(columns, offsetRows, offsetCols);
    }

    @Override
    public void reportCantReadEmpty(List<String> columns, int offsetRows, int offsetCols) {
        sheetRange.reportCantReadEmpty(columns, offsetRows, offsetCols);
    }

    @Override
    public void reportCantReadFormat(List<String> columns, int offsetRows, int offsetCols) {
        sheetRange.reportCantReadFormat(columns, offsetRows, offsetCols);
    }

    @Override
    public void reportCantReadRangeMismatch(List<String> columns, int offsetRows, int offsetCols) {
        sheetRange.reportCantReadRangeMismatch(columns, offsetRows, offsetCols);
    }

    @Override
    public void reportCantReadUnexpectedData(List<String> columns, int offsetRows, int offsetCols) {
        sheetRange.reportCantReadUnexpectedData(columns, offsetRows, offsetCols);
    }

}
