package ru.yandex.direct.excel.processing.validation;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translatable;
import ru.yandex.direct.i18n.bundle.MessageFormatStub;
import ru.yandex.direct.i18n.bundle.TranslationBundle;

@ParametersAreNonnullByDefault
public interface ExcelDefectTranslations extends TranslationBundle {

    ExcelDefectTranslations INSTANCE = I18NBundle.implement(ExcelDefectTranslations.class);

    @MessageFormatStub("Обьявления или группы пренадлежат разным кампаниям")
    Translatable adsOrAdGroupsBelongToDifferentCampaigns();

    @MessageFormatStub("Названия групп не должны быть одинаковыми")
    Translatable duplicateAdGroupTitles();

    @MessageFormatStub("Столбцы из файла не соответствуют ожидаемым")
    Translatable inconsistentColumnTitles();

    @MessageFormatStub("Отсутствует ID группы для существующего объявления")
    Translatable adGroupIdRequiredForExistingAd();

    @MessageFormatStub("Не найдена группа по ID для нового объявления")
    Translatable adGroupByIdNotFound();

    @MessageFormatStub("Не найдена новая группа по имени для нового объявления")
    Translatable newAdGroupByNameNotFound();

    @MessageFormatStub("Нельзя добавлять новое объявление в новую группу для выбранного режима импорта")
    Translatable notAllowedAddNewAdGroupWithNewAdForImportMode();

    @MessageFormatStub("Некорректное значение: {0}")
    Translatable invalidValidForImport(String value);

}
