package ru.yandex.direct.excel.processing.validation.defects;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.excel.processing.model.internalad.ExcelSheetFetchedData;
import ru.yandex.direct.utils.JsonUtils;
import ru.yandex.direct.validation.result.Defect;

@ParametersAreNonnullByDefault
public class Defects {

    public static Defect<Void> adsOrAdGroupsBelongToDifferentCampaigns() {
        return new Defect<>(ExcelDefectIds.ADS_OR_AD_GROUPS_BELONG_TO_DIFFERENT_CAMPAIGNS);
    }

    public static Defect<Void> duplicateAdGroupTitles() {
        return new Defect<>(ExcelDefectIds.DUPLICATE_AD_GROUP_TITLES);
    }

    public static Defect<ExcelDefectParams> inconsistentColumnTitles(ExcelSheetFetchedData<?> sheetFetchedData) {
        var params = ExcelDefectParams.create(sheetFetchedData.getSheetName(),
                JsonUtils.toJson(sheetFetchedData.getFetchedColumnTitles()),
                JsonUtils.toJson(sheetFetchedData.getMappersColumnTitles()));
        return new Defect<>(ExcelDefectIdsWithParams.INCONSISTENT_COLUMN_TITLES, params);
    }

    public static Defect<ExcelDefectParams> adGroupIdRequiredForExistingAd(String sheetName, Long adId) {
        var params = ExcelDefectParams.create(sheetName, adId.toString());
        return new Defect<>(ExcelDefectIdsWithParams.AD_GROUP_ID_REQUIRED_FOR_EXISTING_AD, params);
    }

    public static Defect<ExcelDefectParams> adGroupByIdNotFound(String sheetName, Long adGroupId) {
        var params = ExcelDefectParams.create(sheetName, adGroupId.toString());
        return new Defect<>(ExcelDefectIdsWithParams.AD_GROUP_BY_ID_NOT_FOUND, params);
    }

    public static Defect<ExcelDefectParams> notAllowedAddNewAdGroupWithNewAdForImportMode(String sheetName,
                                                                                          String adGroupName) {
        var params = ExcelDefectParams.create(sheetName, adGroupName);
        return new Defect<>(ExcelDefectIdsWithParams.NOT_ALLOWED_ADD_NEW_AD_GROUP_WITH_NEW_AD_FOR_IMPORT_MODE, params);
    }

    public static Defect<ExcelDefectParams> newAdGroupByNameNotFound(String sheetName, String adGroupName) {
        var params = ExcelDefectParams.create(sheetName, adGroupName);
        return new Defect<>(ExcelDefectIdsWithParams.NEW_AD_GROUP_BY_NAME_NOT_FOUND, params);
    }

}
