package ru.yandex.direct.excel.processing.validation.defects;

import java.util.Objects;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class ExcelDefectParams {
    private final String sheetName;
    private final String value;
    private final String expectedValue;

    private ExcelDefectParams(String sheetName, String value, @Nullable String expectedValue) {
        this.sheetName = sheetName;
        this.value = value;
        this.expectedValue = expectedValue;
    }

    public static ExcelDefectParams create(String sheetName, String value) {
        return new ExcelDefectParams(sheetName, value, null);
    }

    public static ExcelDefectParams create(String sheetName, String value, @Nullable String expectedValue) {
        return new ExcelDefectParams(sheetName, value, expectedValue);
    }

    public String getSheetName() {
        return sheetName;
    }

    public String getValue() {
        return value;
    }

    public String getExpectedValue() {
        return expectedValue;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ExcelDefectParams that = (ExcelDefectParams) o;
        return Objects.equals(sheetName, that.sheetName) &&
                Objects.equals(value, that.value) &&
                Objects.equals(expectedValue, that.expectedValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sheetName, value, expectedValue);
    }

    @Override
    public String toString() {
        return "ExcelDefectParams{" +
                "sheetName='" + sheetName + '\'' +
                ", value='" + value + '\'' +
                ", expectedValue='" + expectedValue + '\'' +
                '}';
    }
}
