package ru.yandex.direct.feature.generator;

import com.beust.jcommander.Parameter;

import ru.yandex.direct.jcommander.Command;

public class GenerateCommand extends Command {

    @Parameter(
            names = {"-c"},
            description = "Path to features yaml file",
            required = true
    )
    public String yamlFile;

    @Parameter(
            names = {"-b"},
            description = "Path to module with backend feature enum",
            required = true
    )
    public String backEnumPath;

    @Parameter(
            names = {"-f"},
            description = "Path to directory with frontend feature enum",
            required = true
    )
    public String frontEnumPath;

    @Parameter(
            names = {"-t"},
            description = "Path to directory with frontend features test config",
            required = true
    )
    public String frontendFeaturesTestConfig;

    protected GenerateCommand() {
        super("generate");
    }
}
