package ru.yandex.direct.feature.generator;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.feature.FeatureType;
import ru.yandex.direct.i18n.I18NBundle;
import ru.yandex.direct.i18n.Translator;

public class FeatureResultTest {
    private static final Translator TRANSLATOR = I18NBundle.makeStubTranslatorFactory().getTranslator(Locale.ENGLISH);

    @Test
    @Disabled("Для генерации yaml из текущего enum")
    public void someTest() {
        for (FeatureName value : FeatureName.values()) {
            var prefix = "  ";
            System.out.println(value.getName() + ":");
            System.out.println(prefix + "text: " + value.getHumanReadableName().translate(TRANSLATOR));
            if (FeatureType.PERMANENT.equals(value.getFeatureType())) {
                System.out.println(prefix + "type: " + value.getFeatureType().name().toLowerCase());
            }
            if (isDeprecated(value)) {
                System.out.println(prefix + "status: deprecated");
            }
            System.out.println();
        }
    }

    Set<String> deprecated = getDeprecated();

    boolean isDeprecated(FeatureName value) {
        return deprecated.contains(value.getName().toLowerCase());
    }

    //взял список фичей включенных на 100% на 18.01.2022
    private static Set<String> getDeprecated() {
        var deprecated = new HashSet<String>();
        deprecated.add("mobile_landing");
        deprecated.add("catalog_closed");
        deprecated.add("cpm_banner");
        deprecated.add("grid_allowed");
        deprecated.add("use_yt_statistic");
        deprecated.add("ab_segments");
        deprecated.add("cpm_banner_video");
        deprecated.add("context_relevance_match_allowed");
        deprecated.add("avg_bid_in_mol");
        deprecated.add("recommendation_availability");
        deprecated.add("recommendation_remove_pages_from_black_list");
        deprecated.add("suggest_yandex_service");
        deprecated.add("suggest_non_yandex_service");
        deprecated.add("save_text_group_in_java");
        deprecated.add("balance_limited_agency_rep");
        deprecated.add("autooverdraft_enabled");
        deprecated.add("bid_modifiers_in_java");
        deprecated.add("aggregator_domains_vk_com");
        deprecated.add("aggregator_domains_instagram_com");
        deprecated.add("aggregator_domains_ok_ru");
        deprecated.add("aggregator_domains_youtube_com");
        deprecated.add("aggregator_domains_sites_google_com");
        deprecated.add("cpm_outdoor");
        deprecated.add("cpm_yndx_frontpage");
        deprecated.add("banner_update_in_java_for_dna");
        deprecated.add("hide_statistics_by_date");
        deprecated.add("new_wallet_with_aggregated_sums");
        deprecated.add("smart_at_search");
        deprecated.add("rmp_stat_tracker_install_enabled");
        deprecated.add("auto_create_billing_aggregates");
        deprecated.add("adgroup_update_in_java_for_dna");
        deprecated.add("banner_prices");
        deprecated.add("desktop_landing");
        deprecated.add("payment_before_moderation");
        deprecated.add("sidebar_enabled_for_dna");
        deprecated.add("cpm_banner_video_stats");
        deprecated.add("aggregated_sums_for_old_clients");
        deprecated.add("brand_lift");
        deprecated.add("banner_aiming_cpm_allowed");
        deprecated.add("canvas_available_adaptive_creative");
        deprecated.add("cpm_outdoor_moderation");
        deprecated.add("banner_prices_on_grid");
        deprecated.add("cpm_outdoor_forecast");
        deprecated.add("minus_words_lib");
        deprecated.add("performance_ad_edit_allowed_in_dna");
        deprecated.add("cpm_indoor");
        deprecated.add("mobile_content_cpc_video_allowed");
        deprecated.add("bid_correction_search_enabled");
        deprecated.add("retargeting_conditions_object_deduplication_enabled");
        deprecated.add("text_campaign_8_sitelinks");
        deprecated.add("billing_order_domains_offline_report_enabled");
        deprecated.add("allow_negative_segments");
        deprecated.add("show_retargeting_grid");
        deprecated.add("show_cpm_banner_campaigns_in_grid");
        deprecated.add("ads_mass_edit_for_dna");
        deprecated.add("show_cpm_video_groups_in_grid");
        deprecated.add("cpm_audio");
        deprecated.add("show_cpm_indoor_groups_in_grid");
        deprecated.add("show_cpm_outdoor_groups_in_grid");
        deprecated.add("banner_aiming_cpm_yndx_frontpage_allowed");
        deprecated.add("landings_cart_allowed");
        deprecated.add("default_different_places");
        deprecated.add("hide_old_text_smart_edit_for_dna");
        deprecated.add("tycoon_organizations");
        deprecated.add("cpm_banner_update_in_java_for_dna");
        deprecated.add("context_limit_inside_strategies");
        deprecated.add("show_daily_budget_recommendations_in_old_interface");
        deprecated.add("new_strategies_policy");
        deprecated.add("strategy_save_in_java");
        deprecated.add("in_app_events_in_rmp_enabled");
        deprecated.add("cpm_adgroup_update_in_java_for_dna");
        deprecated.add("cpm_video_groups_edit_for_dna");
        deprecated.add("recommendation_add_banner_formats");
        deprecated.add("landings_new_templates");
        deprecated.add("text_banner_interests_ret_cond_enabled");
        deprecated.add("attribution_model_in_strategy");
        deprecated.add("uniq_completed_viewers_stat");
        deprecated.add("show_cpm_geoproduct_groups_in_grid");
        deprecated.add("cpm_geoproduct_groups_edit_for_dna");
        deprecated.add("show_cpm_audio_groups_in_grid");
        deprecated.add("landings_advanced_mode_allowed");
        deprecated.add("landings_wysiwyg_allowed");
        deprecated.add("landings_new_sections_allowed");
        deprecated.add("landings_united_panel_allowed");
        deprecated.add("show_new_cpm_edit_for_dna");
        deprecated.add("hide_old_cpm_edit_for_dna");
        deprecated.add("show_goals_stat_in_grid");
        deprecated.add("landings_sites_allowed");
        deprecated.add("mcbanner_dna");
        deprecated.add("relevance_match_for_new_groups_enabled");
        deprecated.add("landings_chats_allowed");
        deprecated.add("show_auto_assigned_organizations");
        deprecated.add("new_keywords_editor_for_dna");
        deprecated.add("show_cpm_price_campaigns_in_grid");
        deprecated.add("landings_reusable_sections_allowed");
        deprecated.add("cpm_audio_normalize");
        deprecated.add("strategy_save_in_java_prevalidate");
        deprecated.add("html5_src_index_iframe");
        deprecated.add("old_phrase_selector_wizard_disabled");
        deprecated.add("landings_wizard_allowed");
        deprecated.add("landings_sprav_allowed");
        deprecated.add("campaign_default_organizations");
        deprecated.add("autopay_with_pay_request");
        deprecated.add("hide_old_text_campaign_edit_for_dna");
        deprecated.add("brandsafety_base_categories_cpm");
        deprecated.add("performance_campaings_edit_allowed_in_dna");
        deprecated.add("cpm_yndx_frontpage_on_grid");
        deprecated.add("video_constructor_enabled");
        deprecated.add("geo_rate_corrections_allowed_for_dna");
        deprecated.add("honest_add_text_adgroup_allowed");
        deprecated.add("edit_cpm_budget_without_restart");
        deprecated.add("keywords_edit_on_banners_page_allowed_for_dna");
        deprecated.add("mass_edit_regions_in_java_for_dna");
        deprecated.add("edit_avg_cpm_without_restart");
        deprecated.add("edit_cpm_period_without_restart");
        deprecated.add("cpm_banner_campaign_add_in_java_for_dna");
        deprecated.add("content_promotion_video_on_grid");
        deprecated.add("disable_all_goals_optimization_for_dna");
        deprecated.add("goals_only_with_campaign_counters_used");
        deprecated.add("new_payment_workflow_enabled");
        deprecated.add("touch_payment_page");
        deprecated.add("default_mobile_preview_enabled_for_dna");
        deprecated.add("default_autobudget_avg_click_with_week_budget");
        deprecated.add("autotargeting_for_touch_campaigns_enabled");
        deprecated.add("adding_organizations_counters_to_campaign_on_adding_organizations_to_ads");
        deprecated.add("first_expanded_sidebar_for_dna");
        deprecated.add("rtb_video_size");
        deprecated.add("cpa_pay_for_conversions_extended_mode");
        deprecated.add("stats_shows_visibility_mrc");
        deprecated.add("cpm_price_campaign");
        deprecated.add("eshows_settings");
        deprecated.add("creation_of_metrika_segments_by_presets_enabled");
        deprecated.add("campaign_modification_goals_validation_tightening");
        deprecated.add("is_enable_prefer_v_card_over_permalink");
        deprecated.add("new_master_token_authentication");
        deprecated.add("canvas_range_ratio");
        deprecated.add("turbo_page_types_enabled_in_mol");
        deprecated.add("new_banner_preview_for_dna");
        deprecated.add("hide_old_show_camps_for_dna");
        deprecated.add("hide_old_cpm_banner_campaign_edit_for_dna");
        deprecated.add("mass_edit_metrika_counters_in_java_for_dna");
        deprecated.add("update_filter_conditions_allowed");
        deprecated.add("lal_segments_enabled");
        deprecated.add("recommendation_add_banner_formats_for_price_sales_correctness");
        deprecated.add("recommendation_add_banner_formats_for_price_sales_correctness_in_parent_campaign");
        deprecated.add("html5_external_requests_inspection");
        deprecated.add("smart_scroll_grid_for_dna");
        deprecated.add("asset_cpm_video_text");
        deprecated.add("asset_cpm_video_logo");
        deprecated.add("asset_cpm_video_button");
        deprecated.add("bulk_ops_banners_edit_creative");
        deprecated.add("canvas_range_ratio_cpc");
        deprecated.add("new_bulk_actions_panel_enabled");
        deprecated.add("show_dna_by_default");
        deprecated.add("userecho_enable_for_dna");
        deprecated.add("enable_phone_filter_in_click_places");
        deprecated.add("use_aggressive_organization_suggest_for_dna");
        deprecated.add("bulk_ops_banners_edit_relevance_match");
        deprecated.add("tags_on_group_allowed_in_dna");
        deprecated.add("allow_step_goals_in_strategies");
        deprecated.add("campaign_creation_steps_enabled_for_dna");
        deprecated.add("asset_tgo_button");
        deprecated.add("collecting_verified_phones_for_new_users");
        deprecated.add("bulk_ops_banners_edit_age_limit");
        deprecated.add("show_aggregated_status_open_beta");
        deprecated.add("landings_hiding_phone_allowed");
        deprecated.add("skip_type_selection_on_first_campaign_dna");
        deprecated.add("enable_non_skippable_video_15_seconds");
        deprecated.add("video_constructor_create_from_scratch_enabled");
        deprecated.add("video_constructor_feed_enabled");
        deprecated.add("adgroup_indivisible_draft_status");
        deprecated.add("turbolanding_autolinking_enabled");
        deprecated.add("mol_page_name_support_enabled");
        deprecated.add("checked_support_chat");
        deprecated.add("new_sitelinks_editor_enabled");
        deprecated.add("support_chat_facelift_for_dna");
        deprecated.add("smart_sort_in_grid_for_dna");
        deprecated.add("show_camp_link_in_grid_cell_enabled_for_dna");
        deprecated.add("pay_for_conversion_cpa_suggest_enabled");
        deprecated.add("image_gallery_with_service_panel_for_dna");
        deprecated.add("organizations_redesign_enabled_for_dna");
        deprecated.add("canvas_cms_encode");
        deprecated.add("bulk_ops_groups_edit_minus_phrase");
        deprecated.add("bulk_ops_campaigns_edit_meaningful_goals");
        deprecated.add("bulk_ops_banners_find_and_replace_text");
        deprecated.add("change_banner_organization_on_default_campaign_organization_change");
        deprecated.add("website_on_campaign_enabled_for_dna");
        deprecated.add("cpa_pay_for_conversions_mobile_apps_allowed");
        deprecated.add("pay_step_in_campaign_creation_enabled_for_dna");
        deprecated.add("new_goals_interface_in_grid_enabled_for_dna");
        deprecated.add("canvas_async_video_creative_creation");
        deprecated.add("cpv_strategies_enabled");
        deprecated.add("replaced_button_view_to_button_columns_in_grid_for_dna");
        deprecated.add("edit_cpm_yndx_frontpage_in_dna");
        deprecated.add("in_banner_creatives_support");
        deprecated.add("bulk_ops_campaigns_edit_strategies");
        deprecated.add("dynamic_only_for_dna");
        deprecated.add("dynamic_groups_edit_allowed_for_dna");
        deprecated.add("dynamic_campaigns_edit_allowed_for_dna");
        deprecated.add("dynamic_ads_edit_allowed_for_dna");
        deprecated.add("conversion_strategy_learning_status_enabled");
        deprecated.add("loading_dna_scripts_before_old_interface_scripts_enabled");
        deprecated.add("landings_new_panel_allowed");
        deprecated.add("mobile_content_only_for_dna");
        deprecated.add("mobile_content_campaigns_edit_allowed_for_dna");
        deprecated.add("new_geo_default_and_suggest");
        deprecated.add("mcbanner_only_for_dna");
        deprecated.add("ydb_json_settings_enabled");
        deprecated.add("ydb_filter_shortcuts_enabled");
        deprecated.add("show_cashback_bonus");
        deprecated.add("hyperlocal_geo_for_text_and_uc_campaigns_enabled_for_dna");
        deprecated.add("change_offer_for_clients_from_turkey");
        deprecated.add("mcbanner_campaign_dna");
        deprecated.add("mobile_content_groups_edit_allowed_for_dna");
        deprecated.add("mobile_content_ads_edit_allowed_for_dna");
        deprecated.add("increased_cpa_limit_for_pay_for_conversion");
        deprecated.add("rmp_impressions_link_enabled");
        deprecated.add("website_on_campaign_all_enabled_for_dna");
        deprecated.add("new_sprav_iframe_enabled");
        deprecated.add("new_campaign_info_strategy_enabled");
        deprecated.add("content_promotion_services_on_grid");
        deprecated.add("cashback_page_enabled");
        deprecated.add("new_cash_payment_enabled");
        deprecated.add("show_conversion_report_for_login");
        deprecated.add("cold_start_for_ecommerce_goals");
        deprecated.add("market_feeds_allowed");
        deprecated.add("enable_promocode_hint");
        deprecated.add("can_have_internal_dont_show_domains");
        deprecated.add("turbo_promo_for_mobile_enabled_for_dna");
        deprecated.add("stop_campaigns_from_grid");
        deprecated.add("creative_frontpage_728_90_disabled");
        deprecated.add("smart_strategy_context_only_for_dna");
        deprecated.add("disable_mail_ru_domain_allowed");
        deprecated.add("enable_sidebar_optimize");
        deprecated.add("campaign_goal_refactoring");
        deprecated.add("brandsafety_base_categories_stat");
        deprecated.add("new_feedback_form");
        deprecated.add("enable_goal_conversion_statistics_for_7_days");
        deprecated.add("enable_hoverable_menu");
        deprecated.add("new_feedback_form_auto_opening");
        deprecated.add("enable_internal_links_in_same_window");
        deprecated.add("do_not_check_passport_karma_for_xls_access");
        deprecated.add("universal_campaigns_enabled_for_uac");
        deprecated.add("uc_suggest_ads_step_sitelinks");
        deprecated.add("uc_suggest_audience_step_phrases");
        deprecated.add("uc_suggest_ads_step_snippet");
        deprecated.add("uc_suggest_ads_step_images");
        deprecated.add("cpm_fixed_data_in_mol");
        deprecated.add("support_chat_notification");
        deprecated.add("new_wallet_warnings_enabled");
        deprecated.add("pay_for_conversion_visible_in_filter_optimization_entity_for_dna");
        deprecated.add("crr_strategy_allowed");
        deprecated.add("is_order_phrase_length_precedence_allowed");
        deprecated.add("universal_campaigns_use_historical_cpa_suggest");
        deprecated.add("universal_campaigns_show_conversions_forecast");
        deprecated.add("rmp_stat_impression_install_enabled");
        deprecated.add("in_app_mobile_targeting");
        deprecated.add("retargeting_only_lal_enabled");
        deprecated.add("brand_lift_cpm_yndx_frontpage");
        deprecated.add("uc_design_for_dna_edit_enabled");
        deprecated.add("grid_banners_new_preview");
        deprecated.add("organization_preview_available_for_dna");
        deprecated.add("sidebar_instruments_menu");
        deprecated.add("site_feeds_allowed");
        deprecated.add("feedback_answer_checkmark");
        deprecated.add("enable_suggestion_for_recommended_goals");
        deprecated.add("bonus_alert_visible_for_dna");
        deprecated.add("white_text_for_mass_stat_button");
        deprecated.add("order_by_status");
        deprecated.add("social_advertising_tgo");
        deprecated.add("new_moderate_send_warn_enabled");
        deprecated.add("sharp_increase_price_enabled");
        deprecated.add("is_metrika_goals_lighter_color_theme_enabled");
        deprecated.add("increase_ad_text_limits");
        deprecated.add("uc_design_for_dna_grid_enabled");
        deprecated.add("new_stat_rollback_notification_enabled");
        deprecated.add("text_campaign_redesign_edit_form");
        deprecated.add("show_skadnetwork_on_new_ios_enabled");
        deprecated.add("show_rmp_on_new_ios_version_enabled");
        deprecated.add("new_chat_notification");
        deprecated.add("use_dynamic_threshold_for_send_order_warnings");
        deprecated.add("universal_campaigns_increase_ad_text_limits");
        deprecated.add("rmp_campaign_redesign_edit_form");
        deprecated.add("show_skadnetwork_on_new_ios_auto_verification_enabled");
        deprecated.add("universal_campaigns_mobile_version_enabled_for_uac");
        deprecated.add("dc3_smart_campaigns_allowed");
        deprecated.add("uc_suggest_audience_step_geo");
        deprecated.add("time_targeting_visible_uc");
        deprecated.add("post_view_attribution_on_uac");
        deprecated.add("show_skadnetwork_on_uac");
        deprecated.add("uc_kotlin_backend_enabled");
        deprecated.add("delete_uac_campaigns_in_kotlin");
        deprecated.add("statuses_uac_campaigns_controller_in_kotlin");
        deprecated.add("uac_get_direct_campaigns_in_kotlin");
        deprecated.add("uac_get_campaigns_ydb_in_kotlin");
        deprecated.add("add_uac_campaigns_in_kotlin");
        deprecated.add("update_uac_campaigns_in_kotlin");
        deprecated.add("new_campaigns_status_filter");
        deprecated.add("support_conversion_strategy_learning_status_for_crr");
        deprecated.add("fix_crr_strategy_allowed");
        deprecated.add("cpm_easy_video_loading");
        deprecated.add("dc3_cpm_campaigns_allowed");
        deprecated.add("uac_mobile_welcome_enabled");
        deprecated.add("rmp_show_video_warning_message_enabled");
        deprecated.add("dc3_dynamic_campaigns_allowed");
        deprecated.add("redesign_campaigns_edit_page_main_settings");
        deprecated.add("sidebar_add_mediaplan_link");
        deprecated.add("campaign_source_uslugi_visible");
        deprecated.add("campaign_source_uslugi_creatable");
        deprecated.add("send_to_mbi_feed_type_yandexmarket");
        deprecated.add("cpm_banner_campaigns_enabled_for_uac");
        deprecated.add("communication_messages_enabled");
        deprecated.add("cashback_page_enabled_for_by_and_kz");
        deprecated.add("conversions_by_campaign_settings");
        deprecated.add("is_rmp_video_number_limit_increased");
        deprecated.add("retargeting_and_user_profile_disabled_for_dna");
        deprecated.add("campaign_statistics_by_own_goals_enabled");
        deprecated.add("hide_autobudget_week_bundle");
        deprecated.add("use_extended_error_codes_for_promocodes_errors");
        deprecated.add("cpv_pay_for_true_view");
        deprecated.add("allow_copy_conversion_strategy_between_logins");
        deprecated.add("reasons_filter_links_in_status_popup");
        deprecated.add("uc_multiple_ads_enabled");
        deprecated.add("velocity_fast_show_dna");
        deprecated.add("disable_autobudget_week_bundle");
        deprecated.add("group_goods_editor_enabled");
        deprecated.add("edit_creatives_on_smart_groups_enabled");
        deprecated.add("group_goods_editor_gallery_enabled");
        deprecated.add("uac_show_rmp_ad_network");
        deprecated.add("uac_enable_keywords");
        deprecated.add("uac_enable_target_price_corrections");
        deprecated.add("uac_click_campaign_strategy");
        deprecated.add("uac_campaign_report_master_in_showcamp");
        deprecated.add("uac_enable_keywords_statistics");
        deprecated.add("enable_uac_link_in_create_campaign_menu_permanent");
        deprecated.add("hide_creative_button");
        deprecated.add("new_text_suggestions_generation_enabled");
        deprecated.add("uac_new_asset_status_calculation");
        deprecated.add("uac_use_asset_reject_reasons");
        deprecated.add("move_key_goals_to_strategy_editor");
        deprecated.add("income_grade_bid_modifier_allowed");
        deprecated.add("banner_preview_gallery");
        deprecated.add("content_uac_in_kotlin");
        deprecated.add("uc_uac_create_brief_in_grut_instead_of_ydb");
        deprecated.add("uac_campaign_type_select_is_hidden");
        deprecated.add("uac_thermometer");
        deprecated.add("campaign_source_uslugi_editable");
        deprecated.add("increase_rmp_text_contents_number");
        deprecated.add("rmp_price_recommendation");
        deprecated.add("in_app_mobile_targeting_custom_events_for_external_trackers");
        deprecated.add("myapps_uac_in_kotlin");
        deprecated.add("content_uac_rmp_in_kotlin");
        deprecated.add("uc_uac_create_ecom_brief_in_grut_instead_of_ydb");
        deprecated.add("cross_device_attribution_types");
        deprecated.add("uac_enable_minus_keywords");
        deprecated.add("uac_enable_kotlin_statistics");
        deprecated.add("direct_birthday_rebranding");
        deprecated.add("collecting_verified_phones_required_for_new_users");
        deprecated.add("content_uac_cpm_in_kotlin");
        deprecated.add("campaigns_promotions_enabled");
        deprecated.add("allow_meaningful_goal_value_from_metrika");
        deprecated.add("enable_do_search_placement_types");
        deprecated.add("bangen_proxy_api_use_v2");
        deprecated.add("is_s2s_tracking_enabled");
        deprecated.add("uac_enable_kotlin_direct_apps");
        deprecated.add("uac_enable_kotlin_geo_suggest");
        deprecated.add("uac_enable_kotlin_region_names");
        deprecated.add("uac_enable_kotlin_tracking_url_impression");
        deprecated.add("disable_autobudget_week_bundle_in_api");
        deprecated.add("enable_kotlin_tracking_url_validation");
        deprecated.add("allow_all_meaningful_goals_for_pay_for_conversion_strategies");
        deprecated.add("enable_tgo_field_recommendations");
        deprecated.add("rmp_tracking_url_from_prev_campaigns_enabled");
        deprecated.add("uac_enable_kotlin_content_statistics_rmp");
        deprecated.add("uac_kotlin_keywords_statistics");
        deprecated.add("uc_uac_create_mobile_content_brief_in_grut_instead_of_ydb");
        deprecated.add("uac_enable_kotlin_tracking_url_validation");
        deprecated.add("grid_campaign_goals_filtration_for_stat");
        deprecated.add("canvas_html5_click_urls");
        deprecated.add("uc_uac_create_media_brief_in_grut_instead_of_ydb");
        deprecated.add("mobile_turbo_creation_disabled");
        deprecated.add("gbp_allowed_for_agency_subclients");
        deprecated.add("internal_group_mass_edit");
        return deprecated;
    }
}
