package ru.yandex.direct.libs.graphql;

import ru.yandex.direct.i18n.Translatable;

/**
 * Исключение, содержащее сообщение, которое можно показывать конечному пользователю
 */
public class GraphqlPublicException extends RuntimeException {
    private final Translatable detailedMessage;

    public GraphqlPublicException(String internalMessage, Translatable detailedMessage) {
        super(internalMessage);
        this.detailedMessage = detailedMessage;
    }

    public GraphqlPublicException(String internalMessage, Translatable detailedMessage, Throwable cause) {
        super(internalMessage, cause);

        this.detailedMessage = detailedMessage;
    }

    public Translatable getDetailedMessage() {
        return detailedMessage;
    }
}
