package ru.yandex.direct.libs.graphql.model;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * Стандартный ответ на запрос к GraphQL-контроллеру.
 * <p>
 * Для соответствия спецификации не возвращаем отсутствующие data, errors и extensions
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GraphqlResponse {
    private Object data;
    private List<Map<String, Object>> errors;
    private Map<Object, Object> extensions;

    public void setData(Object data) {
        this.data = data;
    }

    public GraphqlResponse withData(Object data) {
        this.data = data;
        return this;
    }

    public Object getData() {
        return data;
    }

    public void setErrors(List<Map<String, Object>> errors) {
        this.errors = errors;
    }

    public GraphqlResponse withErrors(List<Map<String, Object>> errors) {
        this.errors = errors;
        return this;
    }

    public List<Map<String, Object>> getErrors() {
        return errors;
    }

    public void setExtensions(Map<Object, Object> extensions) {
        this.extensions = extensions;
    }

    public GraphqlResponse withExtensions(Map<Object, Object> extensions) {
        this.extensions = extensions;
        return this;
    }

    public Map<Object, Object> getExtensions() {
        if (extensions != null && extensions.isEmpty()) {
            return null;
        }
        return extensions;
    }
}
