# -*- coding: utf-8 -*-

from ut_utils import TestModelGeneratorResult, compare_dirs
from yatest.common import source_path, binary_path


class TestCoreModel(TestModelGeneratorResult):
    conf_dir = source_path("direct/libs-internal/grid-core-model/src/main/model-conf")
    generated_dir = source_path("direct/libs-internal/grid-core-model/src/generated/java")

    @classmethod
    def tar_paths(cls):
        return [binary_path("direct/libs-internal/grid-core-model/ut-gen/ut-app/yandex-direct-grid-core-model-ut-gen-app.tar")]

    @classmethod
    def additional_args(cls):
        return ["--rewrite"]

    def test_model(self):
        result, message = compare_dirs(self.generated_dir, self.tmpdir)
        assert result, message + ", please regenerate models or update .conf files"
