package ru.yandex.direct.grid.core.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.core.configuration.CoreConfiguration;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.grid.core.util.yt.YtClusterFreshnessLoader;
import ru.yandex.direct.grid.core.util.yt.YtDynamicSupport;
import ru.yandex.direct.grid.core.util.yt.YtRecommendationsDynamicSupport;
import ru.yandex.direct.grid.core.util.yt.YtStatisticSenecaSasSupport;
import ru.yandex.direct.grid.core.util.yt.YtSyncStatesDynamicSupport;
import ru.yandex.direct.grid.core.util.yt.YtSyncStatesLoader;
import ru.yandex.direct.grid.core.util.yt.YtTestTablesSupport;
import ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorFacade;
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytcomponents.repository.YtClusterFreshnessRepository;
import ru.yandex.direct.ytcomponents.spring.YtComponentsConfiguration;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;

import static ru.yandex.direct.grid.model.entity.campaign.strategy.GdStrategyExtractorHelper.STRATEGIES_EXTRACTORS_BY_TYPES;

@Configuration
@Import({
        CoreConfiguration.class,
        YtComponentsConfiguration.class
})
@ComponentScan(
        basePackages = {
                "ru.yandex.direct.grid.core.entity",
                "ru.yandex.direct.grid.core.frontdb"
        },
        excludeFilters = {
                @ComponentScan.Filter(value = Configuration.class, type = FilterType.ANNOTATION),
        }
)
public class GridCoreConfiguration {

    @Bean
    @Lazy
    public YtClusterFreshnessLoader ytClusterFreshnessLoader(YtProvider ytProvider,
                                                             DirectYtDynamicConfig dynamicConfig,
                                                             YtClusterFreshnessRepository freshnessRepository) {
        return new YtClusterFreshnessLoader(ytProvider, dynamicConfig, freshnessRepository);
    }

    @Bean
    @Lazy
    public YtDynamicSupport ytDynamicSupport(ShardHelper shardHelper, YtProvider ytProvider,
                                             DirectYtDynamicConfig dynamicConfig,
                                             YtClusterFreshnessLoader freshnessLoader,
                                             YtDynamicConfig ytDynamicConfig) {
        return new YtDynamicSupport(shardHelper, ytProvider, dynamicConfig, freshnessLoader, ytDynamicConfig);
    }

    @Bean
    @Lazy
    public YtSyncStatesLoader ytSyncStatesLoader(YtProvider ytProvider,
                                                 DirectYtDynamicConfig dynamicConfig,
                                                 YtClusterFreshnessRepository freshnessRepository) {
        return new YtSyncStatesLoader(ytProvider, dynamicConfig, freshnessRepository);
    }

    @Bean
    @Lazy
    public YtSyncStatesDynamicSupport ytSyncStatesDynamicSupport(YtSyncStatesLoader ytSyncStatesLoader,
                                                                 DirectYtDynamicConfig dynamicConfig) {
        return new YtSyncStatesDynamicSupport(ytSyncStatesLoader, dynamicConfig);
    }

    @Bean
    @Lazy
    public YtStatisticSenecaSasSupport ytStatisticSenecaSasSupport(YtProvider ytProvider,
                                                                   DirectYtDynamicConfig dynamicConfig,
                                                                   YtDynamicConfig ytDynamicConfig) {
        return new YtStatisticSenecaSasSupport(ytProvider, dynamicConfig, ytDynamicConfig);
    }

    @Bean
    @Lazy
    public YtRecommendationsDynamicSupport ytRecommendationsDynamicSupport(ShardHelper shardHelper,
                                                                           YtProvider ytProvider,
                                                                           DirectYtDynamicConfig dynamicConfig,
                                                                           YtClusterFreshnessLoader freshnessLoader,
                                                                           YtDynamicConfig ytDynamicConfig) {
        return new YtRecommendationsDynamicSupport(shardHelper, ytProvider, dynamicConfig,
                freshnessLoader, ytDynamicConfig);
    }

    @Bean
    public GdStrategyExtractorFacade gdStrategyExtractorFacade() {
        return new GdStrategyExtractorFacade(STRATEGIES_EXTRACTORS_BY_TYPES);
    }

    @Bean
    @Lazy
    public YtTestTablesSupport ytTestStatSupport(EnvironmentType environmentType,
                                                 DirectConfig directConfig,
                                                 DirectYtDynamicConfig dynamicConfig,
                                                 YtDynamicConfig ytDynamicConfig) {
        return new YtTestTablesSupport(environmentType, directConfig, dynamicConfig, ytDynamicConfig);
    }
}
