package ru.yandex.direct.grid.core.entity.banner.repository;

import java.util.Collection;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbschema.ppc.enums.BannersStatusarch;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatuspostmoderate;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusshow;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS;
import static ru.yandex.direct.dbschema.ppc.Tables.BS_DEAD_DOMAINS;
import static ru.yandex.direct.dbschema.ppc.Tables.DOMAINS;

@Repository
@ParametersAreNonnullByDefault
public class GridBannerDomainRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public GridBannerDomainRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Возвращает множество id баннеров, которые остановлены мониторингом.
     */
    public Set<Long> getMonitoringStoppedBanners(int shard, Collection<Long> bannerIds) {
        return dslContextProvider.ppc(shard)
                .select(BANNERS.BID)
                .from(BANNERS)
                .leftJoin(DOMAINS).on(DOMAINS.DOMAIN.eq(BANNERS.DOMAIN))
                .leftJoin(BS_DEAD_DOMAINS).on(BS_DEAD_DOMAINS.DOMAIN_ID.eq(DOMAINS.DOMAIN_ID))
                .where(BANNERS.BID.in(bannerIds),
                        BANNERS.STATUS_ARCH.eq(BannersStatusarch.No),
                        BANNERS.STATUS_SHOW.eq(BannersStatusshow.Yes),
                        BANNERS.STATUS_MODERATE.eq(BannersStatusmoderate.Yes),
                        BANNERS.STATUS_POST_MODERATE.eq(BannersStatuspostmoderate.Yes),
                        BS_DEAD_DOMAINS.DOMAIN_ID.isNotNull()
                )
                .fetchSet(BANNERS.BID);
    }
}
