package ru.yandex.direct.grid.core.entity.banner.repository;

import java.util.Map;
import java.util.Optional;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.dbschema.ppc.enums.BannersStatusarch;

public class GridBannerMapping {
    private static final Map<Boolean, String> BOOL_TO_BANNER_STATUS_ARCH = ImmutableMap.of(
            true, BannersStatusarch.Yes.getLiteral(),
            false, BannersStatusarch.No.getLiteral()
    );

    static String booleanFromBannerStatusArch(@Nullable Boolean bannerStatusArch) {
        if (bannerStatusArch == null) {
            return null;
        }

        return Optional.ofNullable(BOOL_TO_BANNER_STATUS_ARCH.get(bannerStatusArch))
                .orElseThrow(
                        () -> new IllegalArgumentException(
                                String.format("No banner status arc for %s", bannerStatusArch)));
    }
}
