package ru.yandex.direct.grid.core.entity.banner.repository;

import java.util.Collection;
import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.core.entity.banner.model.BannerFlags;
import ru.yandex.direct.dbschema.ppc.enums.BannersBannerType;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusactive;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusarch;
import ru.yandex.direct.dbschema.ppc.enums.BannersStatusshow;
import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBanner;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerShowType;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerStatusBsSynced;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerStatusModerate;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerStatusPostModerate;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerStatusSitelinksModerate;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerStatusVCardModeration;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static org.jooq.impl.DSL.noCondition;
import static ru.yandex.direct.dbschema.ppc.tables.Banners.BANNERS;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromSet;
import static ru.yandex.direct.utils.CommonUtils.ifNotNull;

@Repository
@ParametersAreNonnullByDefault
public class GridBannerRepository {
    private static final String OPTS_NO_DISPLAY_HREF = "opts_no_display_href";
    private static final String OPTS_GEO_FLAG = "geoflag";

    private final DslContextProvider dslContextProvider;

    private final JooqReaderWithSupplier<GdiBanner> bannerReader;

    @Autowired
    public GridBannerRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        this.bannerReader = JooqReaderWithSupplierBuilder.builder(GdiBanner::new)
                .readProperty(GdiBanner.ID, fromField(BANNERS.BID))
                .readProperty(GdiBanner.GROUP_ID, fromField(BANNERS.PID))
                .readProperty(GdiBanner.CAMPAIGN_ID, fromField(BANNERS.CID))
                .readProperty(GdiBanner.TYPE, fromField(BANNERS.TYPE)
                        .by(value -> GdiBannerShowType.valueOf(value.getLiteral().toUpperCase())))
                .readProperty(GdiBanner.BANNER_TYPE, fromField(BANNERS.BANNER_TYPE))
                .readProperty(GdiBanner.TITLE, fromField(BANNERS.TITLE))
                .readProperty(GdiBanner.TITLE_EXTENSION, fromField(BANNERS.TITLE_EXTENSION))
                .readProperty(GdiBanner.BODY, fromField(BANNERS.BODY))
                .readProperty(GdiBanner.HREF, fromField(BANNERS.HREF))
                .readProperty(GdiBanner.DOMAIN_ID, fromField(BANNERS.DOMAIN_ID))
                .readProperty(GdiBanner.BS_BANNER_ID, fromField(BANNERS.BANNER_ID))

                .readProperty(GdiBanner.STATUS_SHOW,
                        fromField(BANNERS.STATUS_SHOW).by(value -> value == BannersStatusshow.Yes))
                .readProperty(GdiBanner.STATUS_ACTIVE,
                        fromField(BANNERS.STATUS_ACTIVE).by(value -> value == BannersStatusactive.Yes))
                .readProperty(GdiBanner.STATUS_ARCHIVED,
                        fromField(BANNERS.STATUS_ARCH).by(value -> value == BannersStatusarch.Yes))

                .readProperty(GdiBanner.STATUS_MODERATE, fromField(BANNERS.STATUS_MODERATE)
                        .by(value -> GdiBannerStatusModerate.valueOf(value.getLiteral().toUpperCase())))

                .readProperty(GdiBanner.STATUS_POST_MODERATE, fromField(BANNERS.STATUS_POST_MODERATE)
                        .by(value -> GdiBannerStatusPostModerate.valueOf(value.getLiteral().toUpperCase())))

                .readProperty(GdiBanner.STATUS_SITELINKS_MODERATE, fromField(BANNERS.STATUS_SITELINKS_MODERATE)
                        .by(value -> GdiBannerStatusSitelinksModerate.valueOf(value.getLiteral().toUpperCase())))
                .readProperty(GdiBanner.STATUS_BS_SYNCED, fromField(BANNERS.STATUS_BS_SYNCED)
                        .by(value -> GdiBannerStatusBsSynced.valueOf(value.getLiteral().toUpperCase())))
                .readProperty(GdiBanner.LAST_CHANGE, fromField(BANNERS.LAST_CHANGE))
                .readProperty(GdiBanner.DOMAIN, fromField(BANNERS.DOMAIN))
                .readProperty(GdiBanner.REVERSE_DOMAIN, fromField(BANNERS.REVERSE_DOMAIN))
                .readProperty(GdiBanner.PHONE_FLAG, fromField(BANNERS.PHONEFLAG)
                        .by(value -> GdiBannerStatusVCardModeration.valueOf(value.getLiteral().toUpperCase())))
                .readProperty(GdiBanner.VCARD_ID, fromField(BANNERS.VCARD_ID))

                .readProperty(GdiBanner.SITELINKS_SET_ID, fromField(BANNERS.SITELINKS_SET_ID))

                .readProperty(GdiBanner.FLAGS, fromField(BANNERS.FLAGS)
                        .by(flags ->
                                ifNotNull(flags, value ->
                                        StreamEx
                                                .split(value, ",")
                                                .toSet())))
                .readProperty(GdiBanner.MOD_FLAGS, fromField(BANNERS.FLAGS).by(BannerFlags::fromSource))
                .readProperty(GdiBanner.OPTS_GEO_FLAG, fromSet(BANNERS.OPTS, OPTS_GEO_FLAG))
                .readProperty(GdiBanner.OPTS_NO_DISPLAY_HREF, fromSet(BANNERS.OPTS, OPTS_NO_DISPLAY_HREF))
                .build();
    }

    public List<GdiBanner> getBanners(int shard, Collection<Long> bannerIds, Set<String> clientFeatures) {
        return dslContextProvider.ppc(shard)
                .select(bannerReader.getFieldsToRead())
                .from(BANNERS)
                .where(BANNERS.BID.in(bannerIds))
                .and(!clientFeatures.contains(FeatureName.CREATIVE_FREE_INTERFACE.getName()) ? noCondition() :
                        BANNERS.BANNER_TYPE.notIn(BannersBannerType.performance_main, BannersBannerType.performance))
                .fetch(bannerReader::fromDb);
    }
}
