package ru.yandex.direct.grid.core.entity.banner.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerBannersCreativeStatusModerate;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerCreative;
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerCreativeType;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static ru.yandex.direct.common.jooqmapperex.read.ReaderBuildersEx.fromLongFieldToBoolean;
import static ru.yandex.direct.dbschema.ppc.Tables.BANNERS_PERFORMANCE;
import static ru.yandex.direct.dbschema.ppc.Tables.PERF_CREATIVES;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@Repository
@ParametersAreNonnullByDefault
public class GridCreativeRepository {
    private final DslContextProvider dslContextProvider;

    private final JooqReaderWithSupplier<GdiBannerCreative> creativesJooqReader;

    @Autowired
    public GridCreativeRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        creativesJooqReader = JooqReaderWithSupplierBuilder.builder(GdiBannerCreative::new)
                .readProperty(GdiBannerCreative.BID, fromField(BANNERS_PERFORMANCE.BID))
                .readProperty(GdiBannerCreative.CREATIVE_ID, fromField(BANNERS_PERFORMANCE.CREATIVE_ID))
                .readProperty(GdiBannerCreative.NAME, fromField(PERF_CREATIVES.NAME))
                .readProperty(GdiBannerCreative.PREVIEW_URL, fromField(PERF_CREATIVES.PREVIEW_URL))
                .readProperty(GdiBannerCreative.EXPANDED_PREVIEW_URL, fromField(PERF_CREATIVES.EXPANDED_PREVIEW_URL))
                .readProperty(GdiBannerCreative.WIDTH, fromField(PERF_CREATIVES.WIDTH))
                .readProperty(GdiBannerCreative.HEIGHT, fromField(PERF_CREATIVES.HEIGHT))
                .readProperty(GdiBannerCreative.CREATIVE_TYPE, fromField(PERF_CREATIVES.CREATIVE_TYPE)
                        .by(GdiBannerCreativeType::fromSource))
                .readProperty(GdiBannerCreative.STATUS_MODERATE, fromField(BANNERS_PERFORMANCE.STATUS_MODERATE)
                        .by(GdiBannerBannersCreativeStatusModerate::fromSource))
                .readProperty(GdiBannerCreative.HAS_PACKSHOT, fromLongFieldToBoolean(PERF_CREATIVES.HAS_PACKSHOT))
                .readProperty(GdiBannerCreative.IS_ADAPTIVE, fromLongFieldToBoolean(PERF_CREATIVES.IS_ADAPTIVE))
                .build();
    }

    public Map<Long, GdiBannerCreative> getCreativesData(int shard, Collection<Long> bannerIds) {
        List<GdiBannerCreative> imageDataResult =
                dslContextProvider.ppc(shard).select(creativesJooqReader.getFieldsToRead())
                        .from(BANNERS_PERFORMANCE)
                        .leftJoin(PERF_CREATIVES).on(BANNERS_PERFORMANCE.CREATIVE_ID.eq(PERF_CREATIVES.CREATIVE_ID))
                        .where(BANNERS_PERFORMANCE.BID.in(bannerIds))
                        .fetch(creativesJooqReader::fromDb);

        return listToMap(imageDataResult, GdiBannerCreative::getBid);
    }

    public Map<Long, Long> getBannerIdToCreativeId(int shard, Collection<Long> bannerIds) {
        return dslContextProvider.ppc(shard).select(BANNERS_PERFORMANCE.BID, BANNERS_PERFORMANCE.CREATIVE_ID)
                .from(BANNERS_PERFORMANCE)
                .where(BANNERS_PERFORMANCE.BID.in(bannerIds))
                .fetchMap(BANNERS_PERFORMANCE.BID, BANNERS_PERFORMANCE.CREATIVE_ID);
    }

}
