package ru.yandex.direct.grid.core.entity.banner.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.EntryStream;

import ru.yandex.direct.model.ModelWithId;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.listToMap;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.util.ValidationUtils.convertToValidationResult;

@ParametersAreNonnullByDefault
public class GridAdMassChangeUtils {

    public static <T> Map<Integer, Integer> getIndexMap(Map<Integer, T> validItemsByIndex) {
        List<Integer> indexes = new ArrayList<>(validItemsByIndex.keySet());
        return EntryStream.of(indexes)
                .invert()
                .toMap();
    }

    public static <T extends ModelWithId, D> ValidationResult<List<T>, D> idsValidationToModelValidation(
            ValidationResult<List<Long>, D> idsValidation,
            Collection<T> models,
            Function<Long, T> modelStubCreator) {
        Map<Long, T> idToModel = listToMap(models, ModelWithId::getId);
        List<T> computedModels = mapList(idsValidation.getValue(), id -> idToModel.computeIfAbsent(id,
                modelStubCreator));

        return convertToValidationResult(idsValidation, computedModels);
    }

}
