package ru.yandex.direct.grid.core.entity.banner.service.converter;

import ru.yandex.direct.core.entity.banner.model.BannerWithDisplayHref;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.grid.core.entity.banner.model.GdiReplaceDisplayHrefBanner;
import ru.yandex.direct.model.ModelChanges;

public class GridFindAndReplaceBannerDisplayHrefConverter {

    private GridFindAndReplaceBannerDisplayHrefConverter() {
    }

    /**
     * Получить ModelChanges по GdiReplaceDisplayHrefBanner
     */
    public static ModelChanges<BannerWithSystemFields> toModelChanges(GdiReplaceDisplayHrefBanner banner) {
        switch (banner.getBannerType()) {
            case text:
                return createModelChanges(TextBanner.class, banner);
            case dynamic:
                return createModelChanges(DynamicBanner.class, banner);
            default:
                throw new IllegalArgumentException("Unknown internal banner class for type: " + banner.getBannerType());
        }
    }

    private static <T extends BannerWithDisplayHref> ModelChanges<BannerWithSystemFields> createModelChanges(
            Class<T> clazz, GdiReplaceDisplayHrefBanner banner) {
        return new ModelChanges<>(banner.getBannerId(), clazz)
                .process(banner.getNewDisplayHref(), BannerWithDisplayHref.DISPLAY_HREF)
                .castModelUp(BannerWithSystemFields.class);
    }
}
