package ru.yandex.direct.grid.core.entity.banner.service.converter;

import java.util.List;

import javax.annotation.Nullable;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.model.BannerWithHref;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.core.entity.banner.model.GdiFindAndReplaceBannerHrefItem;
import ru.yandex.direct.grid.core.entity.banner.model.GdiFindAndReplaceBannerHrefItemSitelink;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class GridFindAndReplaceBannerHrefConverter {

    public static ModelChanges<BannerWithSystemFields> gdiBannerHrefToModelChanges(
            GdiFindAndReplaceBannerHrefItem banner,
            @Nullable SitelinkSet sitelinkSet,
            @Nullable String turbolandingParams) {
        switch (banner.getBannerType()) {
            case text:
                return toModelChangesTextBanner(banner.getBannerId(), banner.getNewHref(),
                        ifNotNull(sitelinkSet, SitelinkSet::getId), turbolandingParams);
            case mobile_content:
                return toModelChangesBannerHref(MobileAppBanner.class, banner.getBannerId(), banner.getNewHref());
            case dynamic:
                return toModelChangesDynamicBanner(banner.getBannerId(), banner.getNewHref(),
                        ifNotNull(sitelinkSet, SitelinkSet::getId), turbolandingParams);
            case image_ad:
                if (banner.getImageHash() == null) {
                    return toModelChangesImageCreativeBannerHref(banner.getAdGroupType(), banner.getBannerId(),
                            banner.getNewHref(), turbolandingParams);
                } else {
                    return toModelChangesImageHashBannerHref(banner.getAdGroupType(), banner.getBannerId(),
                            banner.getNewHref(), turbolandingParams);
                }
            case mcbanner:
                return toModelChangesBannerHref(McBanner.class, banner.getBannerId(), banner.getNewHref());
            case cpm_banner:
                return toModelChangesCpmBanner(banner.getBannerId(), banner.getNewHref(), turbolandingParams);
            case cpc_video:
                return toModelChangesCpcVideoBanner(banner.getBannerId(), banner.getNewHref(), turbolandingParams);
            default:
                throw new IllegalArgumentException("Unknown internal banner class for type: " + banner.getBannerType());
        }
    }

    private static <T extends BannerWithHref> ModelChanges<BannerWithSystemFields> toModelChangesBannerHref(
            Class<T> clazz, Long bannerId, String href) {
        return new ModelChanges<>(bannerId, clazz)
                .processNotNull(href, BannerWithHref.HREF)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesImageHashBannerHref(
            AdGroupType adGroupType, Long bannerId, String href, @Nullable String turbolandingParams) {
        boolean isMobile = adGroupType != AdGroupType.BASE;
        return new ModelChanges<>(bannerId, ImageBanner.class)
                .processNotNull(href, ImageBanner.HREF)
                .process(isMobile, ImageBanner.IS_MOBILE_IMAGE)
                .processNotNull(turbolandingParams, ImageBanner.TURBO_LANDING_HREF_PARAMS)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesImageCreativeBannerHref(
            AdGroupType adGroupType, Long bannerId, String href, @Nullable String turbolandingParams) {
        boolean isMobile = adGroupType != AdGroupType.BASE;
        return new ModelChanges<>(bannerId, ImageBanner.class)
                .processNotNull(href, ImageBanner.HREF)
                .process(isMobile, ImageBanner.IS_MOBILE_IMAGE)
                .processNotNull(turbolandingParams, ImageBanner.TURBO_LANDING_HREF_PARAMS)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesTextBanner(
            Long bannerId, @Nullable String href, @Nullable Long sitelinkSetId, @Nullable String turbolandingParams) {
        return new ModelChanges<>(bannerId, TextBanner.class)
                .processNotNull(href, TextBanner.HREF)
                .processNotNull(sitelinkSetId, TextBanner.SITELINKS_SET_ID)
                .processNotNull(turbolandingParams, TextBanner.TURBO_LANDING_HREF_PARAMS)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesCpmBanner(
            Long bannerId, @Nullable String href, @Nullable String turbolandingParams) {
        return new ModelChanges<>(bannerId, CpmBanner.class)
                .processNotNull(href, CpmBanner.HREF)
                .processNotNull(turbolandingParams, CpmBanner.TURBO_LANDING_HREF_PARAMS)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesCpcVideoBanner(
            Long bannerId, @Nullable String href, @Nullable String turbolandingParams) {
        return new ModelChanges<>(bannerId, CpcVideoBanner.class)
                .processNotNull(href, CpcVideoBanner.HREF)
                .processNotNull(turbolandingParams, CpcVideoBanner.TURBO_LANDING_HREF_PARAMS)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesDynamicBanner(
            Long bannerId, @Nullable String href, @Nullable Long sitelinkSetId, @Nullable String turbolandingParams) {
        return new ModelChanges<>(bannerId, DynamicBanner.class)
                .processNotNull(href, DynamicBanner.HREF)
                .processNotNull(sitelinkSetId, DynamicBanner.SITELINKS_SET_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    public static List<Pair<GdiFindAndReplaceBannerHrefItem, SitelinkSet>> toCoreSitelinkSets(ClientId clientId,
                                                                                              List<GdiFindAndReplaceBannerHrefItem> updateBanners) {
        return mapList(updateBanners, banner -> Pair.of(banner, toCoreSitelinkSet(clientId, banner)));
    }

    private static SitelinkSet toCoreSitelinkSet(ClientId clientId, GdiFindAndReplaceBannerHrefItem updateBanner) {
        if (CollectionUtils.isEmpty(updateBanner.getSitelinks())) {
            return null;
        }
        return new SitelinkSet()
                .withClientId(clientId.asLong())
                .withSitelinks(mapList(updateBanner.getSitelinks(),
                        GdiFindAndReplaceBannerHrefItemSitelink::getSitelink));
    }
}
