package ru.yandex.direct.grid.core.entity.banner.service.converter;

import java.util.List;

import javax.annotation.Nullable;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.adgroup.model.AdGroupType;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.ContentPromotionBanner;
import ru.yandex.direct.core.entity.banner.model.CpcVideoBanner;
import ru.yandex.direct.core.entity.banner.model.CpmAudioBanner;
import ru.yandex.direct.core.entity.banner.model.CpmBanner;
import ru.yandex.direct.core.entity.banner.model.CpmGeoPinBanner;
import ru.yandex.direct.core.entity.banner.model.CpmIndoorBanner;
import ru.yandex.direct.core.entity.banner.model.CpmOutdoorBanner;
import ru.yandex.direct.core.entity.banner.model.DynamicBanner;
import ru.yandex.direct.core.entity.banner.model.ImageBanner;
import ru.yandex.direct.core.entity.banner.model.InternalBanner;
import ru.yandex.direct.core.entity.banner.model.McBanner;
import ru.yandex.direct.core.entity.banner.model.MobileAppBanner;
import ru.yandex.direct.core.entity.banner.model.PerformanceBanner;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.core.entity.banner.model.GdiFindAndReplaceBannerTextItem;
import ru.yandex.direct.grid.core.entity.banner.model.GdiFindAndReplaceBannerTextItemSitelink;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.model.ModelProperty;
import ru.yandex.direct.model.ModelWithId;

import static ru.yandex.direct.utils.CommonUtils.ifNotNull;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class GridFindAndReplaceBannerTextConverter {

    private GridFindAndReplaceBannerTextConverter() {
    }

    public static ModelChanges<BannerWithSystemFields> gdiBannerTextToModelChanges(
            GdiFindAndReplaceBannerTextItem banner,
            @Nullable SitelinkSet sitelinkSet,
            String turbolandingParams) {
        // менять вместе с ru.yandex.direct.grid.core.entity.banner.service.
        // GridFindAndReplaceBannerTextService#AVAILABLE_FIELDS_BY_BANNER_TYPE
        // и GridFindAndReplaceBannerTextService#AVAILABLE_FIELDS_BY_AD_GROUP_TYPE
        switch (banner.getBannerType()) {
            case text:
                return toModelChangesTextBanner(banner, ifNotNull(sitelinkSet, SitelinkSet::getId), turbolandingParams);
            case cpc_video:
                return toModelChangesCpcVideoBanner(banner, turbolandingParams);
            case cpm_banner:
                return toModelChangesCpmBannerText(banner, turbolandingParams);
            case cpm_audio:
                return toModelChangesCpmAudioBanner(banner, turbolandingParams);
            case cpm_outdoor:
                return toModelChangesNewCpmOutdoorBanner(banner);
            case cpm_indoor:
                return toModelChangesNewCpmIndoorBanner(banner);
            case mobile_content:
                return toModelChangesNewMobileAppBanner(banner);
            case dynamic:
                return toModelChangesDynamicBannerText(banner, ifNotNull(sitelinkSet, SitelinkSet::getId),
                        turbolandingParams);
            case mcbanner:
                return toModelChangesNewMcBanner(banner);
            case image_ad:
                return toModelChangesImageHashBanner(banner, turbolandingParams);
            case content_promotion:
                return emptyModelChanges(ContentPromotionBanner.class, banner);
            case performance:
                return emptyModelChanges(PerformanceBanner.class, banner);
            case cpm_geo_pin:
                return emptyModelChanges(CpmGeoPinBanner.class, banner);
            case internal:
                return emptyModelChanges(InternalBanner.class, banner);
            default:
                throw new IllegalArgumentException("Unsupported banner type");
        }
    }

    private static <T extends BannerWithSystemFields> ModelChanges<BannerWithSystemFields> emptyModelChanges(
            Class<T> clazz,
            GdiFindAndReplaceBannerTextItem banner) {

        return new ModelChanges<>(banner.getBannerId(), clazz)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesImageHashBanner(
            GdiFindAndReplaceBannerTextItem banner,
            @Nullable String turbolandingParams) {
        var mc = new ModelChanges<>(banner.getBannerId(), ImageBanner.class);
        processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), ImageBanner.HREF);
        processChanges(banner.getUpdateTurbolandingParams(), mc, turbolandingParams,
                ImageBanner.TURBO_LANDING_HREF_PARAMS);

        return mc.castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesCpmAudioBanner(
            GdiFindAndReplaceBannerTextItem banner,
            @Nullable String turbolandingParams) {
        var mc = new ModelChanges<>(banner.getBannerId(), CpmAudioBanner.class);
        processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), CpmAudioBanner.HREF);

        return mc.castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesCpcVideoBanner(
            GdiFindAndReplaceBannerTextItem banner,
            @Nullable String turbolandingParams) {
        var mc = new ModelChanges<>(banner.getBannerId(), CpcVideoBanner.class);

        if (banner.getAdGroupType() == AdGroupType.MOBILE_CONTENT) {
            processChanges(banner.getUpdateTurbolandingParams(), mc, turbolandingParams,
                    CpcVideoBanner.TURBO_LANDING_HREF_PARAMS);
            processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), CpcVideoBanner.HREF);
            return mc.castModelUp(BannerWithSystemFields.class);
        }

        processChanges(banner.getUpdateTitle(), mc, banner.getNewTitle(), CpcVideoBanner.TITLE);
        processChanges(banner.getUpdateBody(), mc, banner.getNewBody(), CpcVideoBanner.BODY);
        processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), CpcVideoBanner.HREF);
        processChanges(banner.getUpdateTurbolandingParams(), mc, turbolandingParams,
                CpcVideoBanner.TURBO_LANDING_HREF_PARAMS);

        return mc.castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesTextBanner(
            GdiFindAndReplaceBannerTextItem banner,
            @Nullable Long sitelinkSetId,
            @Nullable String turbolandingParams) {
        var mc = new ModelChanges<>(banner.getBannerId(), TextBanner.class);
        processChanges(banner.getUpdateTitle(), mc, banner.getNewTitle(), TextBanner.TITLE);
        processChanges(banner.getUpdateTitleExtension(), mc, banner.getNewTitleExtension(),
                TextBanner.TITLE_EXTENSION);
        processChanges(banner.getUpdateBody(), mc, banner.getNewBody(), TextBanner.BODY);
        processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), TextBanner.HREF);
        processChanges(banner.getUpdateDisplayHref(), mc, banner.getNewDisplayHref(),
                TextBanner.DISPLAY_HREF);
        processChanges(banner.getUpdateTurbolandingParams(), mc, turbolandingParams,
                TextBanner.TURBO_LANDING_HREF_PARAMS);

        return mc.processNotNull(sitelinkSetId, TextBanner.SITELINKS_SET_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesCpmBannerText(
            GdiFindAndReplaceBannerTextItem banner,
            @Nullable String turbolandingParams) {
        var mc = new ModelChanges<>(banner.getBannerId(), CpmBanner.class);
        processChanges(banner.getUpdateTitle(), mc, banner.getNewTitle(), CpmBanner.TITLE);
        processChanges(banner.getUpdateTitleExtension(), mc, banner.getNewTitleExtension(),
                CpmBanner.TITLE_EXTENSION);
        processChanges(banner.getUpdateBody(), mc, banner.getNewBody(), CpmBanner.BODY);
        processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), CpmBanner.HREF);
        processChanges(banner.getUpdateTurbolandingParams(), mc, turbolandingParams,
                CpmBanner.TURBO_LANDING_HREF_PARAMS);

        return mc.castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesDynamicBannerText(
            GdiFindAndReplaceBannerTextItem banner,
            @Nullable Long sitelinkSetId,
            @Nullable String turbolandingParams) {
        var mc = new ModelChanges<>(banner.getBannerId(), DynamicBanner.class);
        processChanges(banner.getUpdateBody(), mc, banner.getNewBody(), DynamicBanner.BODY);
        processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), DynamicBanner.HREF);
        processChanges(banner.getUpdateDisplayHref(), mc, banner.getNewDisplayHref(),
                DynamicBanner.DISPLAY_HREF);

        return mc.processNotNull(sitelinkSetId, DynamicBanner.SITELINKS_SET_ID)
                .castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesNewContentPromotionVideoBanner(
            GdiFindAndReplaceBannerTextItem banner) {
        var mc = new ModelChanges<>(banner.getBannerId(), ContentPromotionBanner.class);
        processChanges(banner.getUpdateTitle(), mc, banner.getNewTitle(), ContentPromotionBanner.TITLE);
        processChanges(banner.getUpdateBody(), mc, banner.getNewBody(), ContentPromotionBanner.BODY);

        return mc.castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesNewMobileAppBanner(
            GdiFindAndReplaceBannerTextItem banner) {
        var mc = new ModelChanges<>(banner.getBannerId(), MobileAppBanner.class);
        processChanges(banner.getUpdateTitle(), mc, banner.getNewTitle(), MobileAppBanner.TITLE);
        processChanges(banner.getUpdateBody(), mc, banner.getNewBody(), MobileAppBanner.BODY);
        processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), MobileAppBanner.HREF);

        return mc.castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesNewMcBanner(
            GdiFindAndReplaceBannerTextItem banner) {
        var mc = new ModelChanges<>(banner.getBannerId(), McBanner.class);
        processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), McBanner.HREF);

        return mc.castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesNewCpmOutdoorBanner(
            GdiFindAndReplaceBannerTextItem banner) {
        var mc = new ModelChanges<>(banner.getBannerId(), CpmOutdoorBanner.class);
        processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), CpmOutdoorBanner.HREF);

        return mc.castModelUp(BannerWithSystemFields.class);
    }

    private static ModelChanges<BannerWithSystemFields> toModelChangesNewCpmIndoorBanner(
            GdiFindAndReplaceBannerTextItem banner) {
        var mc = new ModelChanges<>(banner.getBannerId(), CpmIndoorBanner.class);
        processChanges(banner.getUpdateHref(), mc, banner.getNewHref(), CpmIndoorBanner.HREF);

        return mc.castModelUp(BannerWithSystemFields.class);
    }

    public static List<Pair<GdiFindAndReplaceBannerTextItem, SitelinkSet>> toCoreSitelinkSetsForTextUpdate(
            ClientId clientId,
            List<GdiFindAndReplaceBannerTextItem> updateBanners) {
        return mapList(updateBanners, banner -> Pair.of(banner, toCoreSitelinkSetForTextUpdate(clientId, banner)));
    }

    private static SitelinkSet toCoreSitelinkSetForTextUpdate(ClientId clientId,
                                                              GdiFindAndReplaceBannerTextItem updateBanner) {
        if (CollectionUtils.isEmpty(updateBanner.getSitelinks())) {
            return null;
        }
        var sitelinks = mapList(updateBanner.getSitelinks(), GdiFindAndReplaceBannerTextItemSitelink::getSitelink);
        return new SitelinkSet()
                .withClientId(clientId.asLong())
                .withSitelinks(sitelinks);
    }

    private static <V, M extends ModelWithId> void processChanges(boolean needUpdate, ModelChanges<M> mc,
                                                                  V value, ModelProperty<? super M, V> property) {
        if (needUpdate) {
            mc.process(value, property);
        }
    }
}
