package ru.yandex.direct.grid.core.entity.banner.service.internal;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperation;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.core.entity.banner.model.GdiReplaceDisplayHrefBanner;
import ru.yandex.direct.grid.core.entity.banner.service.converter.GridFindAndReplaceBannerDisplayHrefConverter;
import ru.yandex.direct.grid.core.entity.banner.service.internal.container.GridBannerUpdateInfo;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.operation.Operation;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

public class GridBannerDisplayHrefUpdate {

    private final List<GdiReplaceDisplayHrefBanner> updateBanners;
    private final BannersUpdateOperationFactory bannersUpdateOperationFactory;
    private final ClientId clientId;
    private final long operatorUid;

    public GridBannerDisplayHrefUpdate(List<GdiReplaceDisplayHrefBanner> updateBanners,
                                       BannersUpdateOperationFactory bannersUpdateOperationFactory, Long operatorUid,
                                       ClientId clientId) {
        this.bannersUpdateOperationFactory = bannersUpdateOperationFactory;
        this.updateBanners = updateBanners;
        this.operatorUid = operatorUid;
        this.clientId = clientId;
    }

    public GridBannerUpdateInfo preview() {
        return runOperation(op -> op.prepare().orElseGet(op::cancel));
    }

    public GridBannerUpdateInfo replace() {
        return runOperation(Operation::prepareAndApply);
    }

    private GridBannerUpdateInfo runOperation(Function<BannersUpdateOperation<BannerWithSystemFields>,
            MassResult<Long>> function) {
        return createBannersUpdateOperation()
                .map(function)
                .map(result -> new GridBannerUpdateInfo(result, getValidationResultUnchecked(result)))
                .orElseGet(GridBannerUpdateInfo::empty);
    }

    private Optional<BannersUpdateOperation<BannerWithSystemFields>> createBannersUpdateOperation() {
        if (updateBanners.isEmpty()) {
            return Optional.empty();
        }
        List<ModelChanges<BannerWithSystemFields>> bannerChanges =
                mapList(updateBanners, GridFindAndReplaceBannerDisplayHrefConverter::toModelChanges);
        return Optional.of(bannersUpdateOperationFactory.createPartialUpdateOperation(bannerChanges, operatorUid,
                clientId));
    }

    @SuppressWarnings("unchecked")
    private ValidationResult<List<BannerWithSystemFields>, Defect> getValidationResultUnchecked(
            MassResult<Long> bannerResult) {
        return (ValidationResult<List<BannerWithSystemFields>, Defect>) bannerResult.getValidationResult();
    }

}
