package ru.yandex.direct.grid.core.entity.banner.service.internal;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.core.entity.banner.model.GdiFindAndReplaceBannerHrefItem;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.grid.core.entity.banner.service.converter.GridFindAndReplaceBannerHrefConverter.gdiBannerHrefToModelChanges;
import static ru.yandex.direct.grid.core.entity.banner.service.converter.GridFindAndReplaceBannerHrefConverter.toCoreSitelinkSets;

public class GridBannerHrefWithSitelinksUpdate extends AbstractBannerWithSitelinksUpdate<GdiFindAndReplaceBannerHrefItem> {

    public GridBannerHrefWithSitelinksUpdate(BannersUpdateOperationFactory bannersUpdateOperationFactory,
                                             SitelinkSetService sitelinkSetService,
                                             List<GdiFindAndReplaceBannerHrefItem> updateBanners, Long operatorUid,
                                             ClientId clientId) {
        super(bannersUpdateOperationFactory, sitelinkSetService, updateBanners, operatorUid, clientId);
    }

    @Override
    protected List<Pair<GdiFindAndReplaceBannerHrefItem, SitelinkSet>> convertToCoreSitelinkSets(ClientId clientId,
                                                                                                 List<GdiFindAndReplaceBannerHrefItem> updateBanners) {
        return toCoreSitelinkSets(clientId, updateBanners);
    }

    @Override
    protected ModelChanges<BannerWithSystemFields> toModelChanges(
            GdiFindAndReplaceBannerHrefItem banner,
            SitelinkSet sitelinkSet,
            String turbolandingParams) {
        return gdiBannerHrefToModelChanges(banner, sitelinkSet, turbolandingParams);
    }

    @Override
    protected Map<Long, String> convertToTurbolandingsParams(List<GdiFindAndReplaceBannerHrefItem> updateBanners) {
        return StreamEx.of(updateBanners)
                .filter(b -> b.getOldTurbolandingParams() != null
                        && !b.getOldTurbolandingParams().equals(b.getNewTurbolandingParams()))
                .mapToEntry(GdiFindAndReplaceBannerHrefItem::getBannerId,
                        GdiFindAndReplaceBannerHrefItem::getNewTurbolandingParams)
                .toMap();
    }
}
