package ru.yandex.direct.grid.core.entity.banner.service.internal;

import java.util.List;
import java.util.Map;

import one.util.streamex.StreamEx;
import org.apache.commons.lang3.tuple.Pair;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.service.BannersUpdateOperationFactory;
import ru.yandex.direct.core.entity.sitelink.model.SitelinkSet;
import ru.yandex.direct.core.entity.sitelink.service.SitelinkSetService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.grid.core.entity.banner.model.GdiFindAndReplaceBannerTextItem;
import ru.yandex.direct.model.ModelChanges;

import static ru.yandex.direct.grid.core.entity.banner.service.converter.GridFindAndReplaceBannerTextConverter.gdiBannerTextToModelChanges;
import static ru.yandex.direct.grid.core.entity.banner.service.converter.GridFindAndReplaceBannerTextConverter.toCoreSitelinkSetsForTextUpdate;

public class GridBannerWithSitelinksTextUpdate extends AbstractBannerWithSitelinksUpdate<GdiFindAndReplaceBannerTextItem> {

    public GridBannerWithSitelinksTextUpdate(BannersUpdateOperationFactory bannersUpdateOperationFactory,
                                             SitelinkSetService sitelinkSetService,
                                             long operatorUid, ClientId clientId,
                                             List<GdiFindAndReplaceBannerTextItem> updateBanners) {
        super(bannersUpdateOperationFactory, sitelinkSetService, updateBanners, operatorUid, clientId);
    }

    @Override
    protected List<Pair<GdiFindAndReplaceBannerTextItem, SitelinkSet>> convertToCoreSitelinkSets(ClientId clientId,
                                                                                                 List<GdiFindAndReplaceBannerTextItem> updateBanners) {
        return toCoreSitelinkSetsForTextUpdate(clientId, updateBanners);
    }

    @Override
    protected ModelChanges<BannerWithSystemFields> toModelChanges(GdiFindAndReplaceBannerTextItem banner,
                                                                  SitelinkSet sitelinkSet,
                                                                  String turbolandingParams) {
        return gdiBannerTextToModelChanges(banner, sitelinkSet, turbolandingParams);
    }

    @Override
    protected Map<Long, String> convertToTurbolandingsParams(List<GdiFindAndReplaceBannerTextItem> updateBanners) {
        return StreamEx.of(updateBanners)
                .filter(b -> b.getOldTurbolandingParams() != null
                        && !b.getOldTurbolandingParams().equals(b.getNewTurbolandingParams()))
                .mapToEntry(GdiFindAndReplaceBannerTextItem::getBannerId,
                        GdiFindAndReplaceBannerTextItem::getNewTurbolandingParams)
                .toMap();
    }
}
