package ru.yandex.direct.grid.core.entity.banner.service.internal.container;

import java.util.Collections;
import java.util.List;

import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.result.MassResult;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

public class GridBannerUpdateInfo {

    private int updatedBannerCount;
    private ValidationResult<List<BannerWithSystemFields>, Defect> validationResult;


    public GridBannerUpdateInfo(MassResult<Long> bannerResult,
                                ValidationResult<List<BannerWithSystemFields>, Defect> validationResult) {
        this.updatedBannerCount = bannerResult == null ? 0 : (int) validationResult.getSubResults().values().stream()
                .filter(vr -> !vr.hasAnyErrors())
                .count();
        this.validationResult = validationResult;
    }

    public static GridBannerUpdateInfo empty() {
        return new GridBannerUpdateInfo(null, new ValidationResult<>(Collections.emptyList()));
    }

    public ValidationResult<List<BannerWithSystemFields>, Defect> getValidationResult() {
        return validationResult;
    }

    public int getUpdatedBannerCount() {
        return updatedBannerCount;
    }
}
