package ru.yandex.direct.grid.core.entity.banner.service.validation;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.banner.model.BannerWithBannerImage;
import ru.yandex.direct.core.entity.banner.model.BannerWithImage;
import ru.yandex.direct.core.entity.banner.model.BannerWithSystemFields;
import ru.yandex.direct.core.entity.banner.model.TextBanner;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerConstraints.bannerExists;
import static ru.yandex.direct.core.entity.banner.service.validation.BannerConstraints.bannerIsSubClassOfOneOf;
import static ru.yandex.direct.grid.core.entity.banner.service.GridAdMassChangeUtils.idsValidationToModelValidation;
import static ru.yandex.direct.utils.FunctionalUtils.listToMap;

@ParametersAreNonnullByDefault
@Service
public class GridAdMassChangeValidationService {

    @Autowired
    public GridAdMassChangeValidationService() {
    }

    public ValidationResult<List<BannerWithSystemFields>, Defect> validateWithAdTypeCheck(
            List<Long> adIds,
            List<BannerWithSystemFields> banners,
            Collection<Class<?>> superClasses
    ) {
        ListValidationBuilder<Long, Defect> lvb = ListValidationBuilder.of(adIds);
        Map<Long, BannerWithSystemFields> existingBannerById = listToMap(banners, BannerWithSystemFields::getId);
        lvb.checkEach(bannerExists(existingBannerById.keySet()));

        ValidationResult<List<BannerWithSystemFields>, Defect> vr =
                idsValidationToModelValidation(lvb.getResult(), banners, id -> new TextBanner().withId(id));
        ListValidationBuilder<BannerWithSystemFields, Defect> modelLvb = new ListValidationBuilder<>(vr);

        modelLvb.checkEach(bannerIsSubClassOfOneOf(superClasses));

        return modelLvb.getResult();
    }

    public ValidationResult<List<BannerWithSystemFields>, Defect> validateForImagesUpdate(
            List<Long> adIds,
            List<BannerWithSystemFields> banners
    ) {
        var existingBannerById = listToMap(banners, BannerWithSystemFields::getId);
        ListValidationBuilder<Long, Defect> lvb = ListValidationBuilder.of(adIds);
        lvb.checkEach(bannerExists(existingBannerById.keySet()));
        var vr = idsValidationToModelValidation(lvb.getResult(), banners, id -> new TextBanner().withId(id));
        var modelLvb = new ListValidationBuilder<>(vr);
        modelLvb.checkEach(bannerIsSubClassOfOneOf(List.of(BannerWithBannerImage.class, BannerWithImage.class)));
        return modelLvb.getResult();
    }

}
