package ru.yandex.direct.grid.core.entity.bidmodifiers.repository;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;

import static ru.yandex.direct.core.entity.bidmodifiers.repository.mapper.Common.RETARGETING_ADJUSTMENT_FIELDS;
import static ru.yandex.direct.dbschema.ppc.Tables.RETARGETING_MULTIPLIER_VALUES;
import static ru.yandex.direct.dbschema.ppc.tables.HierarchicalMultipliers.HIERARCHICAL_MULTIPLIERS;

@Repository
public class GridBidModifiersRepository {

    private final DslContextProvider dslContextProvider;

    @Autowired
    public GridBidModifiersRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    public Map<Long, List<Long>> getCampaignIdsWithRetargetingBidModifiersByConditionId(int shard,
                                                                                        Collection<Long> retargetingConditionIds) {
        return dslContextProvider.ppc(shard).select(RETARGETING_ADJUSTMENT_FIELDS)
                .select(HIERARCHICAL_MULTIPLIERS.CID, RETARGETING_MULTIPLIER_VALUES.RET_COND_ID)
                .from(HIERARCHICAL_MULTIPLIERS)
                .leftJoin(RETARGETING_MULTIPLIER_VALUES)
                .on(RETARGETING_MULTIPLIER_VALUES.HIERARCHICAL_MULTIPLIER_ID
                        .eq(HIERARCHICAL_MULTIPLIERS.HIERARCHICAL_MULTIPLIER_ID))
                .where(RETARGETING_MULTIPLIER_VALUES.RET_COND_ID.in(retargetingConditionIds))
                .fetchGroups(RETARGETING_MULTIPLIER_VALUES.RET_COND_ID, HIERARCHICAL_MULTIPLIERS.CID);
    }

}
