package ru.yandex.direct.grid.core.entity.campaign.repository;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.grid.model.campaign.GdMobileContentSuggestInfo;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;

import static ru.yandex.direct.dbschema.ppc.Tables.MOBILE_APPS;
import static ru.yandex.direct.dbschema.ppc.Tables.MOBILE_CONTENT;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;
import static ru.yandex.direct.utils.CommonUtils.nvl;

@Repository
@ParametersAreNonnullByDefault
public class GridMobileContentSuggestInfoRepository {
    private final DslContextProvider dslContextProvider;
    private final JooqReaderWithSupplier<GdMobileContentSuggestInfo> reader;

    @Autowired
    public GridMobileContentSuggestInfoRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
        reader = JooqReaderWithSupplierBuilder.builder(GdMobileContentSuggestInfo::new)
                .readProperty(GdMobileContentSuggestInfo.STORE_CONTENT_ID, fromField(MOBILE_CONTENT.STORE_CONTENT_ID)
                        .by(f -> nvl(f, "")))
                .readProperty(GdMobileContentSuggestInfo.STORE_HREF, fromField(MOBILE_APPS.STORE_HREF)
                        .by(f -> nvl(f, "")))
                .readProperty(GdMobileContentSuggestInfo.MOBILE_CONTENT_NAME, fromField(MOBILE_CONTENT.NAME)
                        .by(f -> nvl(f, "")))
                .build();
    }

    /**
     * Получить данные о приложении для саджеста: ссылку на стор, id в сторе и имя
     * @param shard — шард
     * @param mobileAppId — id приложения
     * @return заполненный GdMobileContentSuggestInfo или null, если нет приложения
     */
    public GdMobileContentSuggestInfo getGdMobilecontentInfoForSuggest(int shard, long mobileAppId) {
        var result =  dslContextProvider.ppc(shard)
                .select(reader.getFieldsToRead())
                .from(MOBILE_CONTENT).join(MOBILE_APPS).on(MOBILE_CONTENT.MOBILE_CONTENT_ID
                        .eq(MOBILE_APPS.MOBILE_CONTENT_ID.cast(Long.class)))
                .where(MOBILE_APPS.MOBILE_APP_ID.eq(mobileAppId))
                .fetch(reader::fromDb);
        return result.isEmpty() ? null : result.get(0);
    }
}
