package ru.yandex.direct.grid.core.entity.campaign.service;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.user.model.User;
import ru.yandex.direct.rbac.RbacRole;

import static ru.yandex.direct.core.entity.user.utils.UserUtil.hasOneOfRoles;

@ParametersAreNonnullByDefault
public class GridCampaignAccessServiceUtils {

    public static boolean getCanRemoderateCampaign(User operator) {
        return hasOneOfRoles(operator, RbacRole.SUPER, RbacRole.SUPPORT, RbacRole.PLACER, RbacRole.MANAGER,
                RbacRole.LIMITED_SUPPORT);
    }

}
