package ru.yandex.direct.grid.core.entity.group.repository;

import java.util.Map;
import java.util.function.Predicate;

import javax.annotation.ParametersAreNonnullByDefault;

import com.google.common.collect.ImmutableMap;

import ru.yandex.direct.core.entity.adgroup.model.StatusModerate;
import ru.yandex.direct.core.entity.adgroup.model.StatusPostModerate;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroup;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroupModerationStatus;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroupPrimaryStatus;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroupStatus;

@ParametersAreNonnullByDefault
public class GridAdGroupStatusPredicates {

    public static final Map<GdiGroupModerationStatus, Predicate<GdiGroup>> STATUS_MODERATE_PREDICATES =
            ImmutableMap.<GdiGroupModerationStatus, Predicate<GdiGroup>>builder()
                    .put(GdiGroupModerationStatus.DRAFT, g -> g.getStatusModerate() == StatusModerate.NEW)
                    .put(GdiGroupModerationStatus.REJECTED, g -> g.getStatusModerate() == StatusModerate.NO)
                    .put(GdiGroupModerationStatus.ACCEPTED, g -> g.getStatusModerate() == StatusModerate.YES &&
                            g.getStatusPostModerate() == StatusPostModerate.YES)
                    .put(GdiGroupModerationStatus.PREACCEPTED, g -> (g.getStatusModerate() == StatusModerate.SENDING
                            || g.getStatusModerate() == StatusModerate.SENT
                            || g.getStatusModerate() == StatusModerate.READY)
                            && g.getStatusPostModerate() == StatusPostModerate.YES)
                    .put(GdiGroupModerationStatus.MODERATION, g -> (g.getStatusModerate() == StatusModerate.SENDING
                            || g.getStatusModerate() == StatusModerate.SENT
                            || g.getStatusModerate() == StatusModerate.READY)
                            && (g.getStatusPostModerate() == StatusPostModerate.NEW
                            || g.getStatusPostModerate() == StatusPostModerate.NO)
                            || g.getStatusPostModerate() == StatusPostModerate.READY
                            || g.getStatusPostModerate() == StatusPostModerate.REJECTED
                            || g.getStatusPostModerate() == StatusPostModerate.SENT)
                    .build();

    public static final Map<GdiGroupPrimaryStatus, Predicate<GdiGroupStatus>> ADGROUP_PRIMARY_STATUS_PREDICATES =
            ImmutableMap.<GdiGroupPrimaryStatus, Predicate<GdiGroupStatus>>builder()
                    .put(GdiGroupPrimaryStatus.DRAFT,
                            gs -> gs.getModerationStatus() == GdiGroupModerationStatus.DRAFT)
                    .put(GdiGroupPrimaryStatus.ARCHIVED, gs -> gs.getStateFlags().getArchived())
                    .put(GdiGroupPrimaryStatus.STOPPED, gs -> !gs.getStateFlags().getShowing())
                    .put(GdiGroupPrimaryStatus.MODERATION,
                            gs -> gs.getModerationStatus() == GdiGroupModerationStatus.MODERATION)
                    .put(GdiGroupPrimaryStatus.ACTIVE, gs -> gs.getStateFlags().getShowing() &&
                            (gs.getModerationStatus() == GdiGroupModerationStatus.ACCEPTED
                                    || gs.getModerationStatus() == GdiGroupModerationStatus.PREACCEPTED))
                    .put(GdiGroupPrimaryStatus.REJECTED,
                            gs -> gs.getModerationStatus() == GdiGroupModerationStatus.REJECTED)
                    .build();
}
