package ru.yandex.direct.grid.core.entity.group.service;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.AdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.CallerReferrersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidTypesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ClidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DesktopInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.DeviceIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.FeaturesInPPAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasLCookieAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.HasPassportIdAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InterfaceLangsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.InternalNetworkAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsDefaultYandexSearchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsPPLoggedInAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsVirusedAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.IsYandexPlusAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledApp;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.MobileInstalledAppsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.PlusUserSegmentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryOptionsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.QueryReferersAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SearchTextAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.ShowDatesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.SidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TestIdsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.TimeAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UserAgentsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.UuidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexUidsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YandexuidAgeAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YpCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.model.YsCookiesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserEnginesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.BrowserNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.DeviceVendorsAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsMobileAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTabletAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.IsTouchAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsFamiliesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.OsNamesAdGroupAdditionalTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.UatraitsTargeting;
import ru.yandex.direct.core.entity.adgroupadditionaltargeting.uatraits.model.VersionedTargeting;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargeting;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingBrowserEngines;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingBrowserNames;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingCallerReferrers;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingClidTypes;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingClids;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingDesktopInstalledApps;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingDeviceIds;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingDeviceNames;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingDeviceVendors;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingFeaturesInPP;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingHasLCookie;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingHasPassportId;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingInterfaceLangs;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingInternalNetwork;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsDefaultYandexSearch;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsMobile;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsPPLoggedIn;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsTablet;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsTouch;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsVirused;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingIsYandexPlus;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingMobileInstalledApps;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingOsFamilies;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingOsNames;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingPlusUserSegments;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingQueryOptions;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingQueryReferers;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingSearchText;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingShowDates;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingSids;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingTestIds;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingTime;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingUatraits;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingUserAgents;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingUuids;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingVersioned;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingYandexUids;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingYandexuidAge;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingYpCookies;
import ru.yandex.direct.grid.core.entity.group.model.additionaltargeting.GdiAdditionalTargetingYsCookies;

import static java.util.Map.entry;

@ParametersAreNonnullByDefault
public class AdditionalTargetingConverters {
    private static final Map<Class<?>, Function<AdGroupAdditionalTargeting, ? extends GdiAdditionalTargeting>>
            CONVERTERS = Map.ofEntries(
            entry(
                    HasPassportIdAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingHasPassportId::new, t)),
            entry(
                    IsVirusedAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingIsVirused::new, t)),
            entry(
                    HasLCookieAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingHasLCookie::new, t)),
            entry(
                    InternalNetworkAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingInternalNetwork::new, t)),
            entry(
                    IsMobileAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingIsMobile::new, t)),
            entry(
                    IsTabletAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingIsTablet::new, t)),
            entry(
                    IsTouchAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingIsTouch::new, t)),
            entry(
                    YandexuidAgeAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingYandexuidAge::new, t)
                            .withValue(((YandexuidAgeAdGroupAdditionalTargeting) t).getValue().getValue())),
            entry(
                    YandexUidsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingYandexUids::new, t)
                            .withValue(((YandexUidsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    QueryReferersAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingQueryReferers::new, t)
                            .withValue(((QueryReferersAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    CallerReferrersAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingCallerReferrers::new, t)
                            .withValue(((CallerReferrersAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    InterfaceLangsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingInterfaceLangs::new, t)
                            .withValue(((InterfaceLangsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    UserAgentsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingUserAgents::new, t)
                            .withValue(((UserAgentsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    BrowserEnginesAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingBrowserEngines::new, t)
                            .withValue(convertVersionedValue(((BrowserEnginesAdGroupAdditionalTargeting) t).getValue()))),
            entry(
                    BrowserNamesAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingBrowserNames::new, t)
                            .withValue(convertVersionedValue(((BrowserNamesAdGroupAdditionalTargeting) t).getValue()))),
            entry(
                    OsFamiliesAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingOsFamilies::new, t)
                            .withValue(convertVersionedValue(((OsFamiliesAdGroupAdditionalTargeting) t).getValue()))),
            entry(
                    OsNamesAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingOsNames::new, t)
                            .withValue(convertUatraitsValue(((OsNamesAdGroupAdditionalTargeting) t).getValue()))),
            entry(
                    DeviceVendorsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingDeviceVendors::new, t)
                            .withValue(convertUatraitsValue(((DeviceVendorsAdGroupAdditionalTargeting) t).getValue()))),
            entry(
                    DeviceNamesAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingDeviceNames::new, t)
                            .withValue(((DeviceNamesAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    ShowDatesAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingShowDates::new, t)
                            .withValue(((ShowDatesAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    DesktopInstalledAppsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingDesktopInstalledApps::new, t)
                            .withValue(((DesktopInstalledAppsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    ClidTypesAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingClidTypes::new, t)
                            .withValue(((ClidTypesAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    ClidsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingClids::new, t)
                            .withValue(((ClidsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    QueryOptionsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingQueryOptions::new, t)
                            .withValue(((QueryOptionsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    TestIdsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingTestIds::new, t)
                            .withValue(((TestIdsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    YsCookiesAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingYsCookies::new, t)
                            .withValue(((YsCookiesAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    IsYandexPlusAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingIsYandexPlus::new, t)),
            entry(
                    IsPPLoggedInAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingIsPPLoggedIn::new, t)),
            entry(
                    MobileInstalledAppsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingMobileInstalledApps::new, t)
                            .withValue(StreamEx.of(((MobileInstalledAppsAdGroupAdditionalTargeting) t).getValue())
                                    .map(MobileInstalledApp::getStoreUrl).toImmutableSet())),
            entry(
                    YpCookiesAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingYpCookies::new, t)
                            .withValue(((YpCookiesAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    FeaturesInPPAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingFeaturesInPP::new, t)
                            .withValue(((FeaturesInPPAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    IsDefaultYandexSearchAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingIsDefaultYandexSearch::new, t)),
            entry(
                    SidsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingSids::new, t)
                            .withValue(((SidsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    UuidsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingUuids::new, t)
                            .withValue(((UuidsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    DeviceIdsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingDeviceIds::new, t)
                            .withValue(((DeviceIdsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    PlusUserSegmentsAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingPlusUserSegments::new, t)
                            .withValue(((PlusUserSegmentsAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    SearchTextAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingSearchText::new, t)
                            .withValue(((SearchTextAdGroupAdditionalTargeting) t).getValue())),
            entry(
                    TimeAdGroupAdditionalTargeting.class,
                    t -> convertGdiTargeting(GdiAdditionalTargetingTime::new, t)
                            .withValue(((TimeAdGroupAdditionalTargeting) t).getValue()))
    );

    private AdditionalTargetingConverters() {
    }

    private static <O extends GdiAdditionalTargeting> O convertGdiTargeting(Supplier<O> targetingCreator,
                                                                            AdGroupAdditionalTargeting targeting) {
        O gdiTargeting = targetingCreator.get();
        gdiTargeting
                .withTargetingMode(targeting.getTargetingMode())
                .withJoinType(targeting.getJoinType());
        return gdiTargeting;
    }

    private static List<GdiAdditionalTargetingVersioned> convertVersionedValue(List<? extends VersionedTargeting> value) {
        return value.stream()
                .map(v -> new GdiAdditionalTargetingVersioned()
                        .withTargetingValueEntryId(v.getTargetingValueEntryId())
                        .withMaxVersion(v.getMaxVersion())
                        .withMinVersion(v.getMinVersion()))
                .collect(Collectors.toList());
    }

    private static List<GdiAdditionalTargetingUatraits> convertUatraitsValue(List<? extends UatraitsTargeting> targeting) {
        return targeting.stream()
                .map(v -> new GdiAdditionalTargetingVersioned()
                        .withTargetingValueEntryId(v.getTargetingValueEntryId()))
                .collect(Collectors.toList());
    }

    @Nullable
    public static GdiAdditionalTargeting convert(AdGroupAdditionalTargeting adGroupAdditionalTargeting) {
        var converter = CONVERTERS.get(adGroupAdditionalTargeting.getClass());
        if (converter == null) {
            throw new IllegalArgumentException("Unknown targeting type: " + adGroupAdditionalTargeting.getClass());
        }
        return converter.apply(adGroupAdditionalTargeting);
    }
}
