package ru.yandex.direct.grid.core.entity.group.service;

import java.util.Set;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.adgroup.model.ContentPromotionAdgroupType;
import ru.yandex.direct.core.entity.adgroup.model.StatusBLGenerated;
import ru.yandex.direct.core.entity.relevancematch.model.RelevanceMatchCategory;
import ru.yandex.direct.grid.core.entity.group.container.GdiRelevanceMatchCategory;
import ru.yandex.direct.grid.core.entity.group.model.GdiContentPromotionGroupType;
import ru.yandex.direct.grid.core.entity.group.model.GdiGroupBlGenerationStatus;

import static ru.yandex.direct.utils.FunctionalUtils.mapSet;

@ParametersAreNonnullByDefault
class GridAdGroupMapper {
    static GdiGroupBlGenerationStatus toGdiGroupBlGenerationStatus(StatusBLGenerated statusBlGenerated) {
        return GdiGroupBlGenerationStatus.valueOf(statusBlGenerated.name());
    }

    static GdiContentPromotionGroupType toGdiContentPromotionGroupType(ContentPromotionAdgroupType contentPromotionType) {
        return GdiContentPromotionGroupType.valueOf(contentPromotionType.name());
    }

    @Nullable
    static Set<GdiRelevanceMatchCategory> toGdiRelevanceMatchCategories(
            @Nullable Set<RelevanceMatchCategory> relevanceMatchCategories) {
        return mapSet(relevanceMatchCategories, category
                -> GdiRelevanceMatchCategory.fromTypedValue(category.name()));
    }
}
