package ru.yandex.direct.grid.core.entity.recommendation;

import javax.annotation.Nullable;

import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTree;
import ru.yandex.inside.yt.kosher.impl.ytree.builder.YTreeBuilder;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class RecommendationYtRecord {
    private final long clientId;
    private final int type;
    private final Long cid;
    private final Long pid;
    private final Long bid;
    private final String userKey1;
    private final String userKey2;
    private final String userKey3;
    private final long timestamp;
    private final String data;

    public RecommendationYtRecord(long clientId, int type, Long cid, Long pid, Long bid,
                                  String userKey1, String userKey2, String userKey3, long timestamp, String data) {
        this.clientId = clientId;
        this.type = type;
        this.cid = cid;
        this.pid = pid;
        this.bid = bid;
        this.userKey1 = userKey1;
        this.userKey2 = userKey2;
        this.userKey3 = userKey3;
        this.timestamp = timestamp;
        this.data = data;
    }

    private <T> void setColumn(YTreeBuilder builder, String field, @Nullable T value) {
        if (value == null) {
            builder.key(field).entity();
        } else {
            builder.key(field).value(value);
        }
    }

    public YTreeMapNode buildMapNode() {
        YTreeBuilder builder = YTree.mapBuilder();
        setColumn(builder, "client_id", clientId);
        setColumn(builder, "type", type);
        setColumn(builder, "cid", cid);
        setColumn(builder, "pid", pid);
        setColumn(builder, "bid", bid);
        setColumn(builder, "user_key_1", userKey1);
        setColumn(builder, "user_key_2", userKey2);
        setColumn(builder, "user_key_3", userKey3);
        setColumn(builder, "timestamp", timestamp);
        setColumn(builder, "data", data);
        return builder.buildMap();
    }
}
