package ru.yandex.direct.grid.core.entity.recommendation.service.outdoor;

import java.util.Objects;

import ru.yandex.direct.core.entity.creative.model.VideoFormat;
import ru.yandex.direct.core.entity.placements.model1.BlockSize;

/**
 * Общий тип разрешения с длительностью для сравнения форматов креативов с форматами щитов.
 * Также используется для хранения соотношения сторон и длительности
 */
public class OutdoorVideoFormat {
    private final int width;
    private final int height;
    private final double duration;

    OutdoorVideoFormat(VideoFormat videoFormat, double duration) {
        this.width = videoFormat.getWidth();
        this.height = videoFormat.getHeight();
        this.duration = duration;
    }

    OutdoorVideoFormat(BlockSize resolution, double duration) {
        this.width = resolution.getWidth();
        this.height = resolution.getHeight();
        this.duration = duration;
    }

    OutdoorVideoFormat(int width, int height, double duration) {
        this.width = width;
        this.height = height;
        this.duration = duration;
    }

    int getWidth() {
        return width;
    }

    int getHeight() {
        return height;
    }

    double getDuration() {
        return duration;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        OutdoorVideoFormat that = (OutdoorVideoFormat) o;
        return width == that.width &&
                height == that.height &&
                duration == that.duration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(width, height, duration);
    }
}
