package ru.yandex.direct.grid.core.entity.showcondition.repository;

import java.util.Collection;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import com.fasterxml.jackson.databind.type.CollectionType;
import org.jooq.Condition;
import org.jooq.impl.DSL;

import ru.yandex.direct.common.util.RepositoryUtils;
import ru.yandex.direct.grid.core.entity.retargeting.model.GdiRetargetingBaseStatus;
import ru.yandex.direct.grid.core.entity.retargeting.model.GdiRetargetingConditionRuleItem;
import ru.yandex.direct.grid.schema.yt.tables.BidsRetargetingtableDirect;
import ru.yandex.direct.utils.JsonUtils;

import static ru.yandex.direct.utils.JsonUtils.fromJson;

@ParametersAreNonnullByDefault
public class GridRetargetingMapping {

    private static final CollectionType RETARGETING_CONDITION_RULES = retargetingRules();

    public static List<GdiRetargetingConditionRuleItem> retargetingConditionJsonReader(String conditionJson) {
        return fromJson(conditionJson, RETARGETING_CONDITION_RULES);
    }

    private static CollectionType retargetingRules() {
        return JsonUtils.getObjectMapper().getTypeFactory()
                .constructCollectionType(List.class, GdiRetargetingConditionRuleItem.class);
    }

    public static Condition buildFromBaseStatuses(BidsRetargetingtableDirect bidsTable, Collection<GdiRetargetingBaseStatus> statuses) {
        return statuses.stream()
                .map(status -> GridRetargetingMapping.buildFromBaseStatus(bidsTable, status))
                .reduce(Condition::or)
                .orElse(DSL.trueCondition());
    }

    private static Condition buildFromBaseStatus(BidsRetargetingtableDirect bidsTable, GdiRetargetingBaseStatus status) {
        if (status == GdiRetargetingBaseStatus.ACTIVE) {
            return bidsTable.IS_SUSPENDED.eq(RepositoryUtils.booleanToLong(false));
        } else if (status == GdiRetargetingBaseStatus.SUSPENDED) {
            return bidsTable.IS_SUSPENDED.eq(RepositoryUtils.booleanToLong(true));
        }
        throw new IllegalArgumentException("Unknown status: " + status);
    }
}
