package ru.yandex.direct.grid.core.entity.showcondition.repository;

import java.util.Map;
import java.util.Optional;

import javax.annotation.Nullable;

import com.google.common.collect.ImmutableMap;
import one.util.streamex.EntryStream;

import ru.yandex.direct.grid.core.entity.showcondition.model.GdiShowConditionAutobudgetPriority;
import ru.yandex.direct.grid.core.entity.showcondition.model.GdiShowConditionType;

public class GridShowConditionMapping {
    // Скопировано из Phrase::PRIORITY_VALUES
    private static final Map<Long, GdiShowConditionAutobudgetPriority> NUM_TO_PRIORITY = ImmutableMap.of(
            1L, GdiShowConditionAutobudgetPriority.LOW,
            3L, GdiShowConditionAutobudgetPriority.MEDIUM,
            5L, GdiShowConditionAutobudgetPriority.HIGH
    );

    private static final Map<GdiShowConditionAutobudgetPriority, Long> PRIORITY_TO_NUM =
            ImmutableMap.copyOf(EntryStream.of(NUM_TO_PRIORITY).invert().toMap());

    private static final Map<String, GdiShowConditionType> STRING_TO_TYPE = ImmutableMap.of(
            "keyword", GdiShowConditionType.KEYWORD,
            "relevance_match", GdiShowConditionType.RELEVANCE_MATCH,
            "relevance_match_search", GdiShowConditionType.RELEVANCE_MATCH
    );

    private GridShowConditionMapping() {
    }

    public static GdiShowConditionAutobudgetPriority autobudgetPriorityFromNum(@Nullable Long apNumber) {
        if (apNumber == null) {
            return null;
        }

        return Optional.ofNullable(NUM_TO_PRIORITY.get(apNumber))
                .orElseThrow(
                        () -> new IllegalArgumentException(String.format("No autobudget priority for %s", apNumber)));
    }

    public static Long numFromAutobudgetPriority(@Nullable GdiShowConditionAutobudgetPriority autobudgetPriority) {
        if (autobudgetPriority == null) {
            return null;
        }

        return Optional.ofNullable(PRIORITY_TO_NUM.get(autobudgetPriority))
                .orElseThrow(
                        () -> new IllegalArgumentException(
                                String.format("No autobudget priority for %s", autobudgetPriority)));
    }

    public static GdiShowConditionType typeFromString(String stringType) {
        if (stringType == null) {
            return null;
        }

        return Optional.ofNullable(STRING_TO_TYPE.get(stringType))
                .orElseThrow(
                        () -> new IllegalArgumentException(
                                String.format("Can't match show condition type from %s", stringType)));
    }

    public static String stringFromType(GdiShowConditionType type) {
        return type.name().toLowerCase();
    }
}
