package ru.yandex.direct.grid.core.entity.sync.repository;


import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Field;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.dbutil.wrapper.DslContextProvider;
import ru.yandex.direct.grid.core.entity.sync.container.ServerUuidAndGtidExecutedContainer;

@Repository
@ParametersAreNonnullByDefault
public class MysqlStateRepository {

    private static final Field<String> SERVER_UUID_FIELD = DSL.field("@@SERVER_UUID", String.class);
    private static final Field<String> GTID_EXECUTED_FIELD = DSL.field("@@GLOBAL.GTID_EXECUTED", String.class);

    private final DslContextProvider dslContextProvider;

    @Autowired
    public MysqlStateRepository(DslContextProvider dslContextProvider) {
        this.dslContextProvider = dslContextProvider;
    }

    /**
     * Возвращает идентификатор mysql сервера и @@GLOBAL.GTID_EXECUTED
     * GTID_EXECUTED нужен, чтобы получить текущий GTID(global transaction identifier) для базы
     */
    public ServerUuidAndGtidExecutedContainer getGtidExecuted(int shard) {
        return dslContextProvider.ppc(shard)
                .select(SERVER_UUID_FIELD, GTID_EXECUTED_FIELD)
                .fetchOne(r -> new ServerUuidAndGtidExecutedContainer()
                        .withServerUuid(r.get(SERVER_UUID_FIELD))
                        .withGtidExecuted(r.get(GTID_EXECUTED_FIELD))
                );
    }

}
