package ru.yandex.direct.grid.core.entity.sync.repository;


import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Select;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import ru.yandex.direct.grid.core.entity.sync.model.GdiMysqlSyncStates;
import ru.yandex.direct.grid.core.util.yt.YtDynamicSupport;
import ru.yandex.direct.grid.core.util.yt.mapping.YtFieldMapper;
import ru.yandex.direct.grid.schema.yt.tables.DirectGridMysqlSyncStates;
import ru.yandex.direct.grid.schema.yt.tables.records.DirectGridMysqlSyncStatesRecord;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplier;
import ru.yandex.direct.jooqmapper.read.JooqReaderWithSupplierBuilder;
import ru.yandex.direct.ytwrapper.dynamic.dsl.YtDSL;

import static ru.yandex.direct.grid.schema.yt.Tables.DIRECT_GRID_MYSQL_SYNC_STATES;
import static ru.yandex.direct.jooqmapper.read.ReaderBuilders.fromField;

/**
 * Репозиторий для получения данных о состоянии синхранизации mysql баз в YT'е
 */
@Repository
@ParametersAreNonnullByDefault
public class YtSyncStateRepository {

    private static final DirectGridMysqlSyncStates TABLE = DIRECT_GRID_MYSQL_SYNC_STATES.as("S");

    private final YtDynamicSupport ytSupport;
    private final YtFieldMapper<GdiMysqlSyncStates, DirectGridMysqlSyncStatesRecord> mapper;

    @Autowired
    public YtSyncStateRepository(YtDynamicSupport ytSupport) {
        this.ytSupport = ytSupport;

        JooqReaderWithSupplier<GdiMysqlSyncStates> internalReader =
                JooqReaderWithSupplierBuilder.builder(GdiMysqlSyncStates::new)
                        .readProperty(GdiMysqlSyncStates.DB_NAME, fromField(TABLE.DBNAME))
                        .readProperty(GdiMysqlSyncStates.GTID_SET, fromField(TABLE.GTID_SET))
                        .build();
        mapper = new YtFieldMapper<>(internalReader, TABLE);
    }

    public Optional<String> getGtidSet(int shard) {
        Select query = YtDSL.ytContext()
                .select(mapper.fieldAlias(TABLE.GTID_SET))
                .from(TABLE)
                .where(TABLE.DBNAME.equal(shardToDbName(shard)));

        return ytSupport.selectRows(shard, query).getYTreeRows().stream()
                .map(mapper::fromNode)
                .map(GdiMysqlSyncStates::getGtidSet)
                .findFirst();
    }

    public static String shardToDbName(int shard) {
        return "ppc:" + shard;
    }

}
