package ru.yandex.direct.grid.core.entity.sync.service;

import javax.annotation.ParametersAreNonnullByDefault;

import com.github.shyiko.mysql.binlog.GtidSet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.grid.core.entity.sync.container.ServerUuidAndGtidExecutedContainer;
import ru.yandex.direct.grid.core.entity.sync.repository.MysqlStateRepository;

@Service
@ParametersAreNonnullByDefault
public class MysqlStateService {

    private final MysqlStateRepository mysqlStateRepository;
    private final ShardHelper shardHelper;

    @Autowired
    public MysqlStateService(MysqlStateRepository mysqlStateRepository, ShardHelper shardHelper) {
        this.mysqlStateRepository = mysqlStateRepository;
        this.shardHelper = shardHelper;
    }


    /**
     * Возвращает текущий gtid_set для mysql базы
     *
     * @param login клиента. Нужен, чтобы получить шард
     */
    public GtidSet.UUIDSet getCurrentServerGtidSet(String login) {
        int shard = shardHelper.getShardByLoginStrictly(login);

        return getCurrentServerGtidSet(shard);
    }

    /**
     * Возвращает текущий gtid_set для mysql базы
     *
     * @param clientId id клиента. Нужен, чтобы получить шард
     */
    public GtidSet.UUIDSet getCurrentServerGtidSet(ClientId clientId) {
        int shard = shardHelper.getShardByClientId(clientId);

        return getCurrentServerGtidSet(shard);
    }

    /**
     * Возвращает текущий gtid_set для mysql базы
     */
    public GtidSet.UUIDSet getCurrentServerGtidSet(int shard) {
        ServerUuidAndGtidExecutedContainer container = mysqlStateRepository.getGtidExecuted(shard);

        GtidSet gtidSet = new GtidSet(container.getGtidExecuted());
        return gtidSet.getUUIDSet(container.getServerUuid());
    }

}
