package ru.yandex.direct.grid.core.entity.touchsocdem.service;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.core.entity.bidmodifier.BidModifier;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierDemographics;
import ru.yandex.direct.core.entity.bidmodifier.BidModifierType;
import ru.yandex.direct.core.entity.bidmodifiers.repository.BidModifierLevel;
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService;
import ru.yandex.direct.grid.core.entity.touchsocdem.service.converter.GridTouchSocdemConverter;
import ru.yandex.direct.grid.processing.model.touchsocdem.GdiTouchSocdem;

@Service
@ParametersAreNonnullByDefault
public class GridTouchSocdemService {
    private final BidModifierService bidModifierService;

    @Autowired
    public GridTouchSocdemService(BidModifierService bidModifierService) {
        this.bidModifierService = bidModifierService;
    }

    /**
     * Вычисляет тачёвый соцдем из соцдем корректировки в указанной группе.
     *
     * @see GridTouchSocdemConverter#socdemBidModifierToTouchSocdem(BidModifierDemographics)
     */
    public GdiTouchSocdem getTouchSocdem(int shard, Long adGroupId) {
        List<BidModifier> bidModifiers = bidModifierService.getByAdGroupIds(
                shard, Set.of(adGroupId),
                Set.of(BidModifierType.DEMOGRAPHY_MULTIPLIER),
                Set.of(BidModifierLevel.ADGROUP));
        BidModifier bm = bidModifiers.isEmpty() ? null : bidModifiers.get(0);
        return GridTouchSocdemConverter.socdemBidModifierToTouchSocdem((BidModifierDemographics) bm);
    }
}
