package ru.yandex.direct.grid.core.frontdb.repository;

import java.util.List;

import ru.yandex.direct.ydb.column.Column;
import ru.yandex.direct.ydb.table.Table;

import static com.yandex.ydb.table.values.PrimitiveType.jsonDocument;
import static com.yandex.ydb.table.values.PrimitiveType.uint64;

@SuppressWarnings({"all"})
public class ClientSettings extends Table {
    private static final String TABLE_NAME = "client_settings";

    public final Column<Long> UID = new Column<Long>(this, "uid", uint64()).pk();
    public final Column<Long> CLIENT_ID = new Column<Long>(this, "client_id", uint64()).pk();
    public final Column<String> SETTINGS = new Column<>(this, "settings", jsonDocument());

    private final List<Column> COLUMNS =
            List.of(UID, CLIENT_ID, SETTINGS);

    public ClientSettings() {
        super(TABLE_NAME);
    }

    private ClientSettings(String alias) {
        super(TABLE_NAME, alias);
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

}
