package ru.yandex.direct.grid.core.frontdb.tables;

import java.time.Instant;
import java.util.List;

import ru.yandex.direct.ydb.column.Column;
import ru.yandex.direct.ydb.table.Table;

import static com.yandex.ydb.table.values.PrimitiveType.datetime;
import static com.yandex.ydb.table.values.PrimitiveType.jsonDocument;
import static com.yandex.ydb.table.values.PrimitiveType.uint64;
import static com.yandex.ydb.table.values.PrimitiveType.utf8;

@SuppressWarnings({"all"})
public class FilterShortcutsTable extends Table {
    private static final String TABLE_NAME = "filter_shortcuts";

    public final Column<String> HASH = new Column<String>(this, "hash", utf8()).pk();
    public final Column<Long> CLIENT_ID = new Column<Long>(this, "client_id", uint64()).pk();
    public final Column<Instant> SAVE_TIME = new Column<>(this, "save_time", datetime());
    public final Column<String> FILTER = new Column<>(this, "filter", jsonDocument());

    private final List<Column> COLUMNS = List.of(HASH, CLIENT_ID, SAVE_TIME, FILTER);

    public FilterShortcutsTable() {
        super(TABLE_NAME);
    }

    private FilterShortcutsTable(String alias) {
        super(TABLE_NAME, alias);
    }

    @Override
    public List<Column> getColumns() {
        return COLUMNS;
    }

}
