package ru.yandex.direct.grid.core.util.stats.completestat;

import org.jooq.Field;
import org.jooq.impl.DSL;

import ru.yandex.direct.grid.core.util.stats.goalstat.DirectGoalGridStatData;
import ru.yandex.direct.grid.core.util.stats.goalstat.GridGoalStatTableData;
import ru.yandex.direct.grid.core.util.stats.objstat.AbstractObjectGridStatData;
import ru.yandex.direct.grid.schema.yt.tables.DirectgridgoalsstatBs;
import ru.yandex.direct.grid.schema.yt.tables.DirectgridstatBs;

import static ru.yandex.direct.grid.core.util.stats.GridStatUtils.DEFAULT_AUTOBUDGET_STRATEGY_ID;
import static ru.yandex.direct.grid.core.util.stats.GridStatUtils.DEFAULT_DEAL_ID;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTGRIDSTAT_BS;
import static ru.yandex.direct.ytwrapper.dynamic.dsl.YtDSL.ytIfNull;

public class DirectGridStatData extends AbstractObjectGridStatData implements GridStatTableData<DirectgridstatBs,
        DirectgridgoalsstatBs> {
    public static final DirectGridStatData INSTANCE = new DirectGridStatData();
    private static final DirectgridstatBs statTable = DIRECTGRIDSTAT_BS.as("S");

    private static final Field<Long> EFFECTIVE_STRATEGY_ID = DSL.field("EffectiveStrategyId", Long.class);

    @Override
    public DirectgridstatBs table() {
        return statTable;
    }

    @Override
    public GridGoalStatTableData<DirectgridgoalsstatBs> goalTableData() {
        return new DirectGoalGridStatData();
    }

    @Override
    public GridGoalStatTableData<DirectgridgoalsstatBs> goalTableData(Long goalId) {
        return new DirectGoalGridStatData(goalId);
    }

    @Override
    public Field<Long> campaignId() {
        return statTable.EXPORT_ID;
    }

    @Override
    public Field<Long> campaignIdHash() {
        return statTable.YTHASH;
    }

    @Override
    public Field<Long> currencyId() {
        return statTable.CURRENCY_ID;
    }

    @Override
    public Field<Long> cost() {
        return statTable.COST;
    }

    @Override
    public Field<Long> costCur() {
        return statTable.COST_CUR;
    }

    @Override
    public Field<Long> costTaxFree() {
        return statTable.COST_TAX_FREE;
    }

    @Override
    public Field<Long> priceCur() {
        return statTable.PRICE_CUR;
    }

    @Override
    public Field<Long> shows() {
        return statTable.SHOWS;
    }

    @Override
    public Field<Long> clicks() {
        return statTable.CLICKS;
    }

    @Override
    public Field<Long> goalsNum() {
        return statTable.GOALS_NUM;
    }

    @Override
    public Field<Long> firstPageShows() {
        return statTable.FIRST_PAGE_SHOWS;
    }

    @Override
    public Field<Long> firstPageClicks() {
        return statTable.FIRST_PAGE_CLICKS;
    }

    @Override
    public Field<Long> firstPageSumPosShows() {
        return statTable.FIRST_PAGE_SUM_POS_SHOWS;
    }

    @Override
    public Field<Long> firstPageSumPosClicks() {
        return statTable.FIRST_PAGE_SUM_POS_CLICKS;
    }

    @Override
    public Field<Long> isRmp() {
        return statTable.IS_RMP;
    }

    @Override
    public Field<Long> isFlat() {
        return statTable.IS_FLAT;
    }

    @Override
    public Field<Long> isMobile() {
        return statTable.IS_MOBILE;
    }

    @Override
    public Field<Long> sessionNum() {
        return statTable.SESSION_NUM;
    }

    @Override
    public Field<Long> sessionNumLimited() {
        return statTable.SESSION_NUM_LIMITED;
    }

    @Override
    public Field<Long> bounces() {
        return statTable.BOUNCES;
    }

    @Override
    public Field<Long> sessionDepth() {
        return statTable.SESSION_DEPTH;
    }

    @Override
    public Field<Long> updateTime() {
        return statTable.UPDATE_TIME;
    }

    @Override
    public Field<Long> autobudgetStrategyId() {
        return ytIfNull(statTable.AUTOBUDGET_STRATEGY_ID, DEFAULT_AUTOBUDGET_STRATEGY_ID);
    }

    @Override
    public Field<Long> effectiveAutobudgetStrategyId() {
        return autobudgetStrategyId().as(EFFECTIVE_STRATEGY_ID);
    }

    @Override
    public Field<Long> dealId() {
        return ytIfNull(statTable.DEAL_ID, DEFAULT_DEAL_ID);
    }
}
