package ru.yandex.direct.grid.core.util.stats.goalstat;

import org.jooq.Field;
import org.jooq.impl.DSL;

import ru.yandex.direct.grid.core.util.stats.objstat.AbstractObjectGridStatData;
import ru.yandex.direct.grid.schema.yt.tables.DirectphrasegoalsstatBs;

import static ru.yandex.direct.grid.core.util.stats.GridStatUtils.DEFAULT_AUTOBUDGET_STRATEGY_ID;
import static ru.yandex.direct.grid.core.util.stats.GridStatUtils.DEFAULT_DEAL_ID;
import static ru.yandex.direct.grid.schema.yt.Tables.DIRECTPHRASEGOALSSTAT_BS;
import static ru.yandex.direct.ytwrapper.dynamic.dsl.YtDSL.ytIfNull;

public class DirectGoalPhraseStatData extends AbstractObjectGridStatData implements GridGoalStatTableData<DirectphrasegoalsstatBs> {
    private final DirectphrasegoalsstatBs statTable;

    private static final Field<Long> EFFECTIVE_STRATEGY_ID = DSL.field("EffectiveStrategyId", Long.class);

    public DirectGoalPhraseStatData() {
        statTable = DIRECTPHRASEGOALSSTAT_BS.as("GS");
    }

    public DirectGoalPhraseStatData(Long goalId) {
        statTable = DIRECTPHRASEGOALSSTAT_BS.as("GS" + goalId);
    }

    @Override
    public DirectphrasegoalsstatBs table() {
        return statTable;
    }

    @Override
    public Field<Long> campaignIdHash() {
        return statTable.YTHASH;
    }

    @Override
    public Field<Long> campaignId() {
        return statTable.EXPORT_ID;
    }

    @Override
    public Field<Long> updateTime() {
        return statTable.UPDATE_TIME;
    }

    @Override
    public Field<Long> isFlat() {
        return statTable.IS_FLAT;
    }

    @Override
    public Field<Long> isMobile() {
        return statTable.IS_MOBILE;
    }

    @Override
    public Field<Long> currencyId() {
        return statTable.CURRENCY_ID;
    }

    @Override
    public Field<Long> isRmp() {
        return statTable.IS_RMP;
    }

    @Override
    public Field<Long> goalId() {
        return statTable.GOAL_ID;
    }

    @Override
    public Field<Long> sessionNum() {
        return statTable.SESSION_NUM;
    }

    @Override
    public Field<Long> sessionNumLimited() {
        return statTable.SESSION_NUM_LIMITED;
    }

    @Override
    public Field<Long> sessionLen() {
        return statTable.SESSION_LEN;
    }

    @Override
    public Field<Long> sessionCost() {
        return statTable.SESSION_COST;
    }

    @Override
    public Field<Long> goalsNum() {
        return statTable.GOALS_NUM;
    }

    @Override
    public Field<Long> withShowsGoalsNum() {
        return statTable.WITH_SHOWS_GOALS_NUM;
    }

    @Override
    public Field<Long> sessionDepth() {
        return statTable.SESSION_DEPTH;
    }

    @Override
    public Field<Long> bounces() {
        return statTable.BOUNCES;
    }

    @Override
    public Field<Long> priceCur() {
        return statTable.PRICE_CUR;
    }

    @Override
    public Field<Long> campaignGoalType() {
        return statTable.CAMPAIGN_GOAL_TYPE;
    }

    @Override
    public Field<Long> autobudgetStrategyId() {
        return ytIfNull(statTable.AUTOBUDGET_STRATEGY_ID, DEFAULT_AUTOBUDGET_STRATEGY_ID);
    }

    @Override
    public Field<Long> effectiveAutobudgetStrategyId() {
        return autobudgetStrategyId().as(EFFECTIVE_STRATEGY_ID);
    }

    @Override
    public Field<Long> dealId() {
        return ytIfNull(null, DEFAULT_DEAL_ID);
    }

    public Field<Long> groupId() {
        return statTable.GROUP_EXPORT_ID;
    }
}
