package ru.yandex.direct.grid.core.util.stats.objstat;

import java.util.Map;

import javax.annotation.Nullable;

import org.jooq.Field;
import org.jooq.impl.DSL;

import ru.yandex.direct.ytwrapper.YtUtils;

public abstract class AbstractObjectGridStatData implements GridObjectStatTableData {
    private static final Field<Long> EFFECTIVE_CAMPAIGN_ID = DSL.field("effectiveCampaignId", Long.class);

    @Override
    public Field<Long> effectiveCampaignId(@Nullable Map<Long, Long> masterIdBySubId) {
        return YtUtils.effectiveCampaignIdField(campaignId(), masterIdBySubId).as(EFFECTIVE_CAMPAIGN_ID);
    }

    @Override
    public Field<Long> effectiveCampaignId() {
        return campaignId().as(EFFECTIVE_CAMPAIGN_ID);
    }
}
