package ru.yandex.direct.grid.core.util.stats.objstat;

import java.util.Map;

import javax.annotation.Nullable;

import org.jooq.Field;

public interface GridObjectStatTableData {
    /**
     * Не использовать в WHERE - можно получить full scan таблицы. Фильтрацию нужно делать по полю campaignId.
     * <p>
     * Синтетическое поле для поддержки выборки статистики по мастер-кампаниям с учетом их подлежащих кампаний.
     * Его значение равно id мастер-кампании для подлежащих кампаний, и id самой кампании в противном случае.
     * <p>
     * Данных о связи нет в YT, их надо сначала получить из MySQL для всех интересующих кампаний.
     * Данные достаточно передавать только в момент обращения к полю внутри SELECT.
     *
     * @param masterIdBySubId отображение из подлежащих кампаний в их мастер-кампании
     * @return синтетическое поле, с которым можно производить любые операции
     */
    Field<Long> effectiveCampaignId(@Nullable Map<Long, Long> masterIdBySubId);

    /**
     * Нельзя использовать без наличия поля в SELECT - в таблице этого поля нет, оно строится искусственно.
     * Не использовать в WHERE - можно получить full scan таблицы. Фильтрацию нужно делать по полю campaignId.
     * <p>
     * Синтетическое поле для поддержки выборки статистики по мастер-кампаниям с учетом их подлежащих кампаний.
     * Его значение равно id мастер-кампании для подлежащих кампаний, и id самой кампании в противном случае.
     */
    Field<Long> effectiveCampaignId();

    Field<Long> campaignId();

    Field<Long> campaignIdHash();

    Field<Long> autobudgetStrategyId();

    Field<Long> effectiveAutobudgetStrategyId();
}
