package ru.yandex.direct.grid.core.util.stats_from_query;

import java.util.Collection;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.multitype.entity.LimitOffset;

/**
 * Методы для работы с построением запроса получения общей статистики, через WITH TOTALS
 */
@ParametersAreNonnullByDefault
public class WithTotalsUtils {

    /**
     * Возвращает true когда можно получить общую статистику из запроса
     *
     * @param addWithTotalsToQuery - фича, добавляющая with totals к запросу
     * @param withStatistic        - включена ли статистика
     * @param models               - полученные объекты от запроса
     * @param limitOffset          - лимит
     */
    public static <T> boolean withTotalStats(boolean addWithTotalsToQuery, boolean withStatistic,
                                             Collection<T> models, LimitOffset limitOffset) {
        return addWithTotalsToQuery && withStatistic && models.size() > limitOffset.limit();
    }
}
