package ru.yandex.direct.grid.core.util.yt;

import java.util.Map;
import java.util.Objects;

import com.google.common.collect.ImmutableMap;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * Хранит полную информацию о свежести выбранного кластера динтаблиц
 */
public class ClusterFreshnessInfo {
    /**
     * Таймстемпы в ms по каждому шарду
     */
    public final Map<Integer, Long> shardTimestamps;
    /**
     * Текущий timestamp (тоже в миллисекундах) самой свежей рекомендации в основной таблице рекомендаций
     * Необходим для выбора самого свежего кластера с точки зрения привоза новых данных для рекомендаций
     * (этот процесс выполняется на каждом кластере независимо, и кластера могут делать это с разной скоростью)
     */
    public final long recommendationsTimestamp;

    ClusterFreshnessInfo(Map<Integer, Long> shardTimestamps, long recommendationsTimestamp) {
        checkArgument(!shardTimestamps.isEmpty());
        checkArgument(shardTimestamps.values().stream().allMatch(delay -> delay >= 0));
        checkArgument(recommendationsTimestamp >= 0);
        //
        this.shardTimestamps = ImmutableMap.copyOf(shardTimestamps);
        this.recommendationsTimestamp = recommendationsTimestamp;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClusterFreshnessInfo that = (ClusterFreshnessInfo) o;
        return recommendationsTimestamp == that.recommendationsTimestamp &&
                Objects.equals(shardTimestamps, that.shardTimestamps);
    }

    @Override
    public int hashCode() {
        return Objects.hash(shardTimestamps, recommendationsTimestamp);
    }
}
