package ru.yandex.direct.grid.core.util.yt;

import java.util.List;
import java.util.Optional;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Select;

import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContextProvider;
import ru.yandex.direct.ytwrapper.dynamic.selector.ClusterChooser;
import ru.yandex.direct.ytwrapper.model.YtCluster;
import ru.yandex.yt.ytclient.wire.UnversionedRowset;

import static com.google.common.base.Preconditions.checkArgument;
import static ru.yandex.direct.ytwrapper.model.YtCluster.SENECA_SAS;

/**
 * Этот саппорт нужен как временный фикс на время работ во Владимире, чтобы не забирать статистику из кластера
 * seneca-man
 * так как она наливается с Арнольда, который будет недоступен
 * YtDyncamicSupport смотрит только на свежесть таблиц mysql-sync, а свежесть таблиц статистики надо определять
 * по-другому
 * см коммент https://st.yandex-team.ru/DIRECT-138089#602e5db9f99e4b631e974da3
 * todo https://st.yandex-team.ru/DIRECT-138089
 */
@ParametersAreNonnullByDefault
public class YtStatisticSenecaSasSupport {
    private final YtDynamicContextProvider<Void> gridYtDynamicContextProvider;

    public YtStatisticSenecaSasSupport(YtProvider ytProvider, DirectYtDynamicConfig dynamicConfig,
                                       YtDynamicConfig ytDynamicConfig) {
        checkArgument(!dynamicConfig.getClusters().isEmpty(), "We need at least one cluster");

        SenecaSasClusterChooser clusterChooser = new SenecaSasClusterChooser();
        gridYtDynamicContextProvider = new YtDynamicContextProvider<>(clusterChooser, ytProvider,
                ytDynamicConfig.defaultSelectRowsTimeout());
    }

    private static class SenecaSasClusterChooser implements ClusterChooser<Void> {
        @Nonnull
        @Override
        public Optional<YtCluster> getCluster(@Nullable Void param) {
            return Optional.of(SENECA_SAS);
        }

        @Nonnull
        @Override
        public Optional<List<YtCluster>> getClustersOrdered(@Nullable Void param) {
            return Optional.of(List.of(SENECA_SAS));
        }
    }

    public UnversionedRowset selectStatistics(Select query) {
        return gridYtDynamicContextProvider.getContext(null).executeSelect(query);
    }
}
