package ru.yandex.direct.grid.core.util.yt;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.Select;

import ru.yandex.direct.config.DirectConfig;
import ru.yandex.direct.env.EnvironmentType;
import ru.yandex.direct.ytcomponents.config.DirectDynTestTablesMapping;
import ru.yandex.direct.ytcomponents.config.DirectYtDynamicConfig;
import ru.yandex.direct.ytwrapper.client.YtClusterConfigProvider;
import ru.yandex.direct.ytwrapper.client.YtClusterTypesafeConfigProvider;
import ru.yandex.direct.ytwrapper.client.YtProvider;
import ru.yandex.direct.ytwrapper.dynamic.YtDynamicConfig;
import ru.yandex.direct.ytwrapper.dynamic.YtQueryComposer;
import ru.yandex.direct.ytwrapper.dynamic.context.YtDynamicContextProvider;
import ru.yandex.direct.ytwrapper.dynamic.selector.TestClusterChooser;
import ru.yandex.yt.ytclient.wire.UnversionedRowset;

import static com.google.common.base.Preconditions.checkArgument;

/**
 * Класс для подмены путей к таблицам YT с данными по статистике в рантайме(например, для e2e-тестов фронта)
 */
@ParametersAreNonnullByDefault
public class YtTestTablesSupport {
    private final YtDynamicContextProvider<Void> gridYtDynamicContextProvider;
    private final YtProvider ytProvider;

    public YtTestTablesSupport(EnvironmentType environmentType,
                               DirectConfig directConfig,
                               DirectYtDynamicConfig dynamicConfig,
                               YtDynamicConfig ytDynamicConfig) {
        checkArgument(!dynamicConfig.getYtTestStatClusters().isEmpty(), "We need at least one cluster");

        DirectDynTestTablesMapping tablesMappings = new DirectDynTestTablesMapping(dynamicConfig);
        YtQueryComposer ytQueryComposer = createQueryComposer(tablesMappings, environmentType);
        ytProvider = createYtProvider(directConfig, ytDynamicConfig, ytQueryComposer);

        TestClusterChooser clusterChooser = new TestClusterChooser(
                dynamicConfig
                        .getYtTestStatClusters().stream().findFirst().orElse(null)
        );
        gridYtDynamicContextProvider = new YtDynamicContextProvider<>(clusterChooser, ytProvider,
                ytDynamicConfig.defaultSelectRowsTimeout());
    }

    public YtProvider getYtProvider() {
        return ytProvider;
    }

    public UnversionedRowset selectStatistics(Select query) {
        return gridYtDynamicContextProvider.getContext(null).executeSelect(query);
    }

    private YtProvider createYtProvider(DirectConfig directConfig, YtDynamicConfig dynConfig,
                                        YtQueryComposer ytQueryComposer) {
        DirectConfig ytConfig = directConfig.getBranch("yt");
        YtClusterConfigProvider ytClusterConfigProvider = new YtClusterTypesafeConfigProvider(ytConfig.getConfig());
        return new YtProvider(ytClusterConfigProvider, dynConfig, ytQueryComposer);
    }

    private YtQueryComposer createQueryComposer(
            DirectDynTestTablesMapping tablesMappings,
            EnvironmentType environmentType
    ) {
        boolean enablePrettyPrint = environmentType.isDevelopment();
        return new YtQueryComposer(tablesMappings, enablePrettyPrint);
    }
}
